package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetDataset {
	private PetDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Jimminy", 1),
			new Pet(2, "Cisco", 2),
			new Pet(3, "Phoenix", 3),
			new Pet(4, "Rocky", 3),
			new Pet(5, "Tallulah", 4)
		};
	}
	
	
	
	
	public static Pet[] petWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = Pet ->
			binarySearch(ids, Pet.getIdPet()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet Pet(int id) {
		return stream(pets())
			.filter(Pet -> Pet.getIdPet() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return Pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Jane", 4);
	}
	
	public static String newName() {
		return "John";
	}
	
	public static int newIdMaster() {
		return 12;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newIdMaster());
	}
}