package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.*;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {

	@Test
	public void testPetIntStringStringInt() {
		final int id = 1;
		final String name = "Laika";
		final String kind = "Perro";
		final int owner = 1;
		
		final Pet pet = new Pet(id, name, kind, owner);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getKind(), is(equalTo(kind)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringIntNullName() {
		new Pet(1, null, "Perro", 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringIntNullKind() {
		new Pet(1, "Laika", null, 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringIntNullOwner() {
		Integer owner = null;
		new Pet(1, "Laika", "Perro", owner);
	}
	
	@Test
	public void testSetName() {
		final int id = 1;
		final String kind = "Perro";
		final int owner = 1;
		
		final Pet pet = new Pet(id, "Laika", kind,owner);
		pet.setName("Alaska");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Alaska")));
		assertThat(pet.getKind(), is(equalTo(kind)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Laika", "Perro", 1);
		
		pet.setName(null);
	}
	
	@Test
	public void testSetKind() {
		final int id = 1;
		final String name = "Laika";
		final int owner = 1;
		
		final Pet pet = new Pet(id, name, "Perro", owner);
		pet.setKind("Gato");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getKind(), is(equalTo("Gato")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullKind() {
		final Pet pet = new Pet(1, "Laika", "Perro", 1);
		
		pet.setKind(null);
	}
	
	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", "Surname A", 1);
		final Pet petB = new Pet(1, "Name B", "Surname B", 1);
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "kind", "owner")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
	
	

}
