package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * An entity that represents a pet.
 * 
 * @author Noelia García Hervella
 */
public class Pet {
	private int id;
	private String name;
	private String kind;
    private int owner;
	
	// Constructor needed for the JSON conversion
	Pet() {}
	
	/**
	 * Constructs a new instance of {@link Pet}.
	 *
	 * @param id identifier of the pet.
	 * @param name name of the pet.
	 * @param surname surname of the pet.
	 */
	public Pet(int id, String name, String kind, int owner) {
		this.id = id;
		this.setName(name);
		this.setKind(kind);
        this.owner = owner;
	}
	
	/**
	 * Returns the identifier of the pet.
	 * 
	 * @return the identifier of the pet.
	 */
	public int getId() {
		return id;
	}

	/**
	 * Returns the name of the pet.
	 * 
	 * @return the name of the pet.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the name of this pet.
	 * 
	 * @param name the new name of the pet.
	 * @throws NullPointerException if the {@code name} is {@code null}.
	 */
	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}

	/**
	 * Returns the surname of the pet.
	 * 
	 * @return the surname of the pet.
	 */
	public String getKind() {
		return kind;
	}

	/**
	 * Set the surname of this pet.
	 * 
	 * @param surname the new surname of the pet.
	 * @throws NullPointerException if the {@code surname} is {@code null}.
	 */
	public void setKind(String surname) {
		this.kind = requireNonNull(surname, "Kind can't be null");
	}


    /**
	 * Returns the id of the owner.
	 * 
	 * @return the id  of the owner.
	 */
	public int getOwner() {
		return owner;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}



}
