(window["webpackJsonp"] = window["webpackJsonp"] || []).push([["modules-pets-pets-module"],{

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-form/pets-form.component.html":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-form/pets-form.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\r\n  <form id=\"people-form\" class=\"mb-5 mb-10\">\r\n    <input name=\"id\" type=\"hidden\" value=\"\"/>\r\n  \r\n    <div class=\"row\">\r\n      <div class=\"col-sm-4\">\r\n        <input name=\"name\" type=\"text\" value=\"\" placeholder=\"Nombre\" class=\"form-control\" required [(ngModel)]=\"name\"/>\r\n      </div>\r\n  \r\n      <div class=\"col-sm-5\">\r\n        <input name=\"kind\" type=\"text\" value=\"\" placeholder=\"Tipo\" class=\"form-control\" required\r\n               [(ngModel)]=\"kind\"/>\r\n      </div>\r\n  \r\n      <div class=\"col-sm-3\">\r\n        <button id=\"btnSubmit\" class=\"btn btn-primary\"\r\n                (click)=\"onModify()\">{{pet.id === undefined ? 'Crear' : 'Editar'}}</button>\r\n        <button id=\"btnClear\" class=\"btn\" (click)=\"onClean()\">Limpiar</button>\r\n      </div>\r\n    </div>\r\n  </form>\r\n\r\n");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-list/pets-list.component.html":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-list/pets-list.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\r\n<table id=\"people-list\" class=\"table\">\r\n  <thead>\r\n  <tr class=\"row\">\r\n    <th class=\"col-sm-4\">Nombre</th>\r\n    <th class=\"col-sm-5\">Tipo</th>\r\n    <th class=\"col-sm-3\">&nbsp;</th>\r\n  </tr>\r\n  </thead>\r\n  <tbody>\r\n    <tr *ngFor=\"let pet of pets\" class=\"row\" id=\"pet-{{pet.id}}\">\r\n      <td class=\"col-sm-4 name\">{{pet.name}}</td>\r\n      <td class=\"col-sm-5 surname\">{{pet.kind}}</td>\r\n      <td class=\"col-sm-3\">\r\n        <button class=\"btn btn-primary edit\" (click)=\"onEdit(pet)\">Edit</button>\r\n        <button class=\"btn btn-warning delete\" (click)=\"onDelete(pet)\">Delete</button>\r\n      </td>\r\n    </tr>\r\n  </tbody>\r\n</table>\r\n\r\n\r\n");

/***/ }),

/***/ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-main/pets-main.component.html":
/*!******************************************************************************************************************!*\
  !*** ./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-main/pets-main.component.html ***!
  \******************************************************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("<!--\r\n<h1 class=\"display-5 mt-3 mb-3\">Personas</h1>\r\n<app-people-form [person]=\"activePerson\" (clean)=\"onCleanForm()\" (modify)=\"onModifyForm($event)\"></app-people-form>\r\n<app-people-list [people]=\"people\" (edit)=\"onEdit($event)\" (delete)=\"onDelete($event)\"></app-people-list>\r\n-->\r\n<h1 class=\"display-5 mt-3 mb-3\">Mascotas</h1>\r\n\r\n\r\n<app-pets-form [pet]=\"activePet\" [owner]=\"id\" (clean)=\"onCleanForm()\" (modify)=\"onModifyForm($event)\"></app-pets-form>\r\n<app-pets-list [pets]=\"pets\" (delete)=\"onDelete($event)\" (edit)=\"onEdit($event)\"></app-pets-list>\r\n<button class=\"btn btn-primary edit\" (click)=\"back()\">Atrás</button>");

/***/ }),

/***/ "./src/app/modules/pets/components/pets-form/pets-form.component.scss":
/*!****************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-form/pets-form.component.scss ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL21vZHVsZXMvcGV0cy9jb21wb25lbnRzL3BldHMtZm9ybS9wZXRzLWZvcm0uY29tcG9uZW50LnNjc3MifQ== */");

/***/ }),

/***/ "./src/app/modules/pets/components/pets-form/pets-form.component.ts":
/*!**************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-form/pets-form.component.ts ***!
  \**************************************************************************/
/*! exports provided: PetsFormComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsFormComponent", function() { return PetsFormComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm2015/router.js");
/* harmony import */ var _models_pet_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../models/pet.model */ "./src/app/modules/pets/models/pet.model.ts");




let PetsFormComponent = class PetsFormComponent {
    constructor(route) {
        this.route = route;
        this.clean = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.modify = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    set pet(pet) {
        this.activePet = pet;
        this.name = pet.name;
        this.kind = pet.kind;
    }
    get pet() {
        return this.activePet;
    }
    onClean() {
        this.clean.emit();
    }
    onModify() {
        this.modify.emit({
            id: this.pet.id,
            name: this.name,
            kind: this.kind,
            owner: this.owner
        });
    }
};
PetsFormComponent.ctorParameters = () => [
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"] }
];
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Number)
], PetsFormComponent.prototype, "owner", void 0);
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"])
], PetsFormComponent.prototype, "clean", void 0);
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"])
], PetsFormComponent.prototype, "modify", void 0);
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _models_pet_model__WEBPACK_IMPORTED_MODULE_3__["PetModel"]),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_models_pet_model__WEBPACK_IMPORTED_MODULE_3__["PetModel"]])
], PetsFormComponent.prototype, "pet", null);
PetsFormComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
        selector: 'app-pets-form',
        template: tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! raw-loader!./pets-form.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-form/pets-form.component.html")).default,
        styles: [tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! ./pets-form.component.scss */ "./src/app/modules/pets/components/pets-form/pets-form.component.scss")).default]
    }),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_router__WEBPACK_IMPORTED_MODULE_2__["ActivatedRoute"]])
], PetsFormComponent);



/***/ }),

/***/ "./src/app/modules/pets/components/pets-list/pets-list.component.scss":
/*!****************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-list/pets-list.component.scss ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL21vZHVsZXMvcGV0cy9jb21wb25lbnRzL3BldHMtbGlzdC9wZXRzLWxpc3QuY29tcG9uZW50LnNjc3MifQ== */");

/***/ }),

/***/ "./src/app/modules/pets/components/pets-list/pets-list.component.ts":
/*!**************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-list/pets-list.component.ts ***!
  \**************************************************************************/
/*! exports provided: PetsListComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsListComponent", function() { return PetsListComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");


let PetsListComponent = class PetsListComponent {
    constructor() {
        this.pets = [];
        this.delete = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
        this.edit = new _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"]();
    }
    onDelete(pet) {
        this.delete.emit(pet);
    }
    onEdit(pet) {
        this.edit.emit(pet);
    }
};
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Input"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", Array)
], PetsListComponent.prototype, "pets", void 0);
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"])
], PetsListComponent.prototype, "delete", void 0);
tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Output"])(),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:type", _angular_core__WEBPACK_IMPORTED_MODULE_1__["EventEmitter"])
], PetsListComponent.prototype, "edit", void 0);
PetsListComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
        selector: 'app-pets-list',
        template: tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! raw-loader!./pets-list.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-list/pets-list.component.html")).default,
        styles: [tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! ./pets-list.component.scss */ "./src/app/modules/pets/components/pets-list/pets-list.component.scss")).default]
    }),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [])
], PetsListComponent);



/***/ }),

/***/ "./src/app/modules/pets/components/pets-main/pets-main.component.scss":
/*!****************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-main/pets-main.component.scss ***!
  \****************************************************************************/
/*! exports provided: default */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony default export */ __webpack_exports__["default"] = ("\n/*# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IiIsImZpbGUiOiJzcmMvYXBwL21vZHVsZXMvcGV0cy9jb21wb25lbnRzL3BldHMtbWFpbi9wZXRzLW1haW4uY29tcG9uZW50LnNjc3MifQ== */");

/***/ }),

/***/ "./src/app/modules/pets/components/pets-main/pets-main.component.ts":
/*!**************************************************************************!*\
  !*** ./src/app/modules/pets/components/pets-main/pets-main.component.ts ***!
  \**************************************************************************/
/*! exports provided: PetsMainComponent */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsMainComponent", function() { return PetsMainComponent; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");
/* harmony import */ var _services_pets_service__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../services/pets.service */ "./src/app/modules/pets/services/pets.service.ts");
/* harmony import */ var rxjs_operators__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! rxjs/operators */ "./node_modules/rxjs/_esm2015/operators/index.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm2015/router.js");





let PetsMainComponent = class PetsMainComponent {
    constructor(petsService, route, router) {
        this.petsService = petsService;
        this.route = route;
        this.router = router;
        this.pets = [];
        this.clearActivePet();
    }
    ngOnInit() {
        this.id = this.route.snapshot.params.person;
        this.petsService.list(this.id)
            .subscribe(pets => this.pets = pets);
    }
    onCleanForm() {
        this.clearActivePet();
    }
    clearActivePet() {
        this.activePet = { id: undefined, name: '', kind: '', owner: undefined };
    }
    back() {
        this.router.navigate(['/']);
    }
    onDelete(pet) {
        if (confirm(`¿Estás seguro de que deseas eliminar a ${pet.name}?`)) {
            this.petsService.delete(pet)
                .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["mergeMap"])(() => this.petsService.list(pet.owner)))
                .subscribe(pets => this.pets = pets);
        }
    }
    onEdit(pet) {
        this.activePet = pet;
        console.log("Noe");
        console.log(this.activePet);
    }
    onModifyForm(pet) {
        if (pet.id === undefined) {
            this.petsService.create(pet)
                .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["mergeMap"])(() => this.petsService.list(pet.owner)))
                .subscribe(pets => {
                this.pets = pets;
                this.clearActivePet();
            });
        }
        else {
            this.petsService.modify(pet)
                .pipe(Object(rxjs_operators__WEBPACK_IMPORTED_MODULE_3__["mergeMap"])(() => this.petsService.list(pet.owner)))
                .subscribe(pets => {
                this.pets = pets;
                this.clearActivePet();
            });
        }
    }
};
PetsMainComponent.ctorParameters = () => [
    { type: _services_pets_service__WEBPACK_IMPORTED_MODULE_2__["PetsService"] },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"] },
    { type: _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"] }
];
PetsMainComponent = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Component"])({
        selector: 'app-pets-main',
        template: tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! raw-loader!./pets-main.component.html */ "./node_modules/raw-loader/dist/cjs.js!./src/app/modules/pets/components/pets-main/pets-main.component.html")).default,
        styles: [tslib__WEBPACK_IMPORTED_MODULE_0__["__importDefault"](__webpack_require__(/*! ./pets-main.component.scss */ "./src/app/modules/pets/components/pets-main/pets-main.component.scss")).default]
    }),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_services_pets_service__WEBPACK_IMPORTED_MODULE_2__["PetsService"],
        _angular_router__WEBPACK_IMPORTED_MODULE_4__["ActivatedRoute"],
        _angular_router__WEBPACK_IMPORTED_MODULE_4__["Router"]])
], PetsMainComponent);



/***/ }),

/***/ "./src/app/modules/pets/models/pet.model.ts":
/*!**************************************************!*\
  !*** ./src/app/modules/pets/models/pet.model.ts ***!
  \**************************************************/
/*! exports provided: PetModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetModel", function() { return PetModel; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");

class PetModel {
}


/***/ }),

/***/ "./src/app/modules/pets/pets-routing.module.ts":
/*!*****************************************************!*\
  !*** ./src/app/modules/pets/pets-routing.module.ts ***!
  \*****************************************************/
/*! exports provided: PetsRoutingModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsRoutingModule", function() { return PetsRoutingModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");
/* harmony import */ var _angular_router__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/router */ "./node_modules/@angular/router/fesm2015/router.js");
/* harmony import */ var _components_pets_main_pets_main_component__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./components/pets-main/pets-main.component */ "./src/app/modules/pets/components/pets-main/pets-main.component.ts");




const routes = [
    {
        path: '',
        component: _components_pets_main_pets_main_component__WEBPACK_IMPORTED_MODULE_3__["PetsMainComponent"]
    }
];
let PetsRoutingModule = class PetsRoutingModule {
};
PetsRoutingModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        imports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"].forChild(routes)],
        exports: [_angular_router__WEBPACK_IMPORTED_MODULE_2__["RouterModule"]]
    })
], PetsRoutingModule);



/***/ }),

/***/ "./src/app/modules/pets/pets.module.ts":
/*!*********************************************!*\
  !*** ./src/app/modules/pets/pets.module.ts ***!
  \*********************************************/
/*! exports provided: PetsModule */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsModule", function() { return PetsModule; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");
/* harmony import */ var _angular_common__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common */ "./node_modules/@angular/common/fesm2015/common.js");
/* harmony import */ var _pets_routing_module__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./pets-routing.module */ "./src/app/modules/pets/pets-routing.module.ts");
/* harmony import */ var _components_pets_list_pets_list_component__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./components/pets-list/pets-list.component */ "./src/app/modules/pets/components/pets-list/pets-list.component.ts");
/* harmony import */ var _components_pets_form_pets_form_component__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./components/pets-form/pets-form.component */ "./src/app/modules/pets/components/pets-form/pets-form.component.ts");
/* harmony import */ var _components_pets_main_pets_main_component__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./components/pets-main/pets-main.component */ "./src/app/modules/pets/components/pets-main/pets-main.component.ts");
/* harmony import */ var _angular_forms__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! @angular/forms */ "./node_modules/@angular/forms/fesm2015/forms.js");








let PetsModule = class PetsModule {
};
PetsModule = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["NgModule"])({
        declarations: [
            _components_pets_form_pets_form_component__WEBPACK_IMPORTED_MODULE_5__["PetsFormComponent"],
            _components_pets_list_pets_list_component__WEBPACK_IMPORTED_MODULE_4__["PetsListComponent"],
            _components_pets_main_pets_main_component__WEBPACK_IMPORTED_MODULE_6__["PetsMainComponent"]
        ],
        imports: [
            _angular_common__WEBPACK_IMPORTED_MODULE_2__["CommonModule"],
            _angular_forms__WEBPACK_IMPORTED_MODULE_7__["FormsModule"],
            _pets_routing_module__WEBPACK_IMPORTED_MODULE_3__["PetsRoutingModule"]
        ]
    })
], PetsModule);



/***/ }),

/***/ "./src/app/modules/pets/services/pets.service.ts":
/*!*******************************************************!*\
  !*** ./src/app/modules/pets/services/pets.service.ts ***!
  \*******************************************************/
/*! exports provided: PetsService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "PetsService", function() { return PetsService; });
/* harmony import */ var tslib__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! tslib */ "./node_modules/tslib/tslib.es6.js");
/* harmony import */ var _angular_core__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! @angular/core */ "./node_modules/@angular/core/fesm2015/core.js");
/* harmony import */ var _angular_common_http__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! @angular/common/http */ "./node_modules/@angular/common/fesm2015/http.js");
/* harmony import */ var _environments_environment__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../../environments/environment */ "./src/environments/environment.ts");




let PetsService = class PetsService {
    constructor(http) {
        this.http = http;
    }
    list(id) {
        return this.http.get(`${_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].restApi}/pets?owner=${id}`);
    }
    delete(pet) {
        return this.http.delete(`${_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].restApi}/pets/${pet.id}`);
    }
    modify(pet) {
        const data = new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpParams"]()
            .set('name', pet.name)
            .set('kind', pet.kind)
            .set('owner', pet.owner.toString());
        return this.http.put(`${_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].restApi}/pets/${pet.id}`, data);
    }
    create(pet) {
        const data = new _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpParams"]()
            .set('name', pet.name)
            .set('kind', pet.kind)
            .set('owner', pet.owner.toString());
        return this.http.post(`${_environments_environment__WEBPACK_IMPORTED_MODULE_3__["environment"].restApi}/pets`, data);
    }
};
PetsService.ctorParameters = () => [
    { type: _angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"] }
];
PetsService = tslib__WEBPACK_IMPORTED_MODULE_0__["__decorate"]([
    Object(_angular_core__WEBPACK_IMPORTED_MODULE_1__["Injectable"])({
        providedIn: 'root'
    }),
    tslib__WEBPACK_IMPORTED_MODULE_0__["__metadata"]("design:paramtypes", [_angular_common_http__WEBPACK_IMPORTED_MODULE_2__["HttpClient"]])
], PetsService);



/***/ })

}]);
//# sourceMappingURL=modules-pets-pets-module-es2015.js.map