package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;


public class PetsDataset {
	
	private PetsDataset() {}

	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1,"Laika", "Perro", 1),
			new Pet(2,"Alaska", "Gato", 1),
			new Pet(3,"Lucky", "Perro", 1),
			new Pet(4,"Luck", "Gato", 1),
			new Pet(5,"Pancho", "Perro", 1),
			new Pet(6,"Chikita", "Gato", 1),
			new Pet(7,"Bethoven", "Perro", 1),
			new Pet(8,"Bella", "Perro", 1),
			new Pet(9,"Puppi", "Gato", 1),
			new Pet(10,"Piolin", "Perro", 1),
		};
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}
	
	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Silvestre", "Perro", 1);
	}
	
	public static String newName() {
		return "Sultán";
	}
	
	public static String newKind() {
		return "Gato";
	}
	
	public static int newOwner() {
		return 1;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newKind(), newOwner());
	}

}
