import { Injectable } from '@angular/core';
import {HttpClient, HttpHeaders, HttpParams} from '@angular/common/http';
import {environment} from '../../../../environments/environment';
import {Observable} from 'rxjs';
import {PetModel} from '../models/pet.model';

@Injectable({
  providedIn: 'root'
})
export class PetsService {

  constructor(private readonly http: HttpClient) { }



  public list(id: number): Observable<PetModel[]>{
    return this.http.get<PetModel[]>(`${environment.restApi}/pets?owner=${id}`);
  }

  public delete(pet: PetModel): Observable<number> {
    return this.http.delete<number>(`${environment.restApi}/pets/${pet.id}`);
  }

  public modify(pet: PetModel): Observable<PetModel> {
    const data = new HttpParams()
      .set('name', pet.name)
      .set('kind', pet.kind)
      .set('owner', pet.owner.toString());

    return this.http.put<PetModel>(`${environment.restApi}/pets/${pet.id}`, data);
  }

  public create(pet: PetModel): Observable<PetModel> {
    const data = new HttpParams()
      .set('name', pet.name)
      .set('kind', pet.kind)
      .set('owner', pet.owner.toString());

    return this.http.post<PetModel>(`${environment.restApi}/pets`, data);
  }
}
