import { Component, EventEmitter, OnInit, Input, Output } from '@angular/core';
import { PetModel} from '../../models/pet.model';
@Component({
  selector: 'app-pets-list',
  templateUrl: './pets-list.component.html',
  styleUrls: ['./pets-list.component.scss']
})
export class PetsListComponent  {
  
  @Input()
  public pets: PetModel[] = [];

  @Output()
  public readonly delete: EventEmitter<PetModel>;

  @Output()
  public readonly edit: EventEmitter<PetModel>;

  constructor() { 
    this.delete = new EventEmitter<PetModel>();
    this.edit = new EventEmitter<PetModel>();
  }

  public onDelete(pet: PetModel) {
    this.delete.emit(pet);
  }

  public onEdit(pet: PetModel) {
    this.edit.emit(pet);
  }

  

}
