import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import {ActivatedRoute} from '@angular/router';
import { PetModel } from '../../models/pet.model';

@Component({
  selector: 'app-pets-form',
  templateUrl: './pets-form.component.html',
  styleUrls: ['./pets-form.component.scss']
})
export class PetsFormComponent {
  public activePet: PetModel;
  @Input()
  public owner: number;

  @Output()
  public readonly clean: EventEmitter<never>;

  @Output()
  public readonly modify: EventEmitter<PetModel>;

  public name: string;
  public kind: string;
  
  constructor(
    private route: ActivatedRoute
  ) { 
    this.clean = new EventEmitter<never>();
    this.modify = new EventEmitter<PetModel>();
  }

  @Input()
  public set pet(pet: PetModel) {
    this.activePet = pet;
    this.name = pet.name;
    this.kind = pet.kind;
  }

  public get pet(): PetModel {
    return this.activePet;
  }

  public onClean() {
    this.clean.emit();
  }

  public onModify() {
    this.modify.emit({
      id: this.pet.id,
      name: this.name,
      kind: this.kind,
      owner: this.owner
    });
  }

}
