package es.uvigo.esei.daa.entities;

import org.junit.Test;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

/**
 * Created by cya on 3/7/17.
 */
public class PetUnitTest {
    @Test
    public void testPetIntStringInt() {
        final int id = 1;
        final String name = "John";
        final int ownerID = 2;

        final Pet pet = new Pet(id, name, ownerID);

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo(name)));
        assertThat(pet.getownerID(), is(equalTo(ownerID)));
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringNullName() {
        new Pet(1, null, 2);
    }

    @Test(expected = NullPointerException.class)
    public void testPetIntStringStringInvalidOwnerID() {
        new Pet(1, "Pet McPetface", (Integer) null);
    }

    @Test
    public void testSetName() {
        final int id = 1;
        final int ownerID = 2;

        final Pet pet = new Pet(id, "Mr. Friskies", ownerID);
        pet.setName("Pet McPetface");

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo("Pet McPetface")));
        assertThat(pet.getownerID(), is(equalTo(ownerID)));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNullName() {
        final Pet pet = new Pet(1, "Pet McPetface", 2);

        pet.setName(null);
    }

    @Test
    public void testSetOwnerID() {
        final int id = 1;
        final String name = "Pet McPetface";

        final Pet pet = new Pet(id, name, 2);
        pet.setownerID(3);

        assertThat(pet.getId(), is(equalTo(id)));
        assertThat(pet.getName(), is(equalTo(name)));
        assertThat(pet.getownerID(), is(equalTo(3)));
    }

    @Test(expected = NullPointerException.class)
    public void testSetNullOwnerID() {
        final Pet pet = new Pet(1, "Pet McPetface", 2);

        pet.setownerID((Integer) null);
    }

    //TODO ownerID can't be less than 1. Also comparing and hashing methods are not implemented

}
