package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * Entity that represents a pet from a person
 *
 * Created by cya on 2/9/17.
 */
public class Pet {
    private int id;
    private String name;
    private Person owner;

    // Constructor needed for the JSON conversion
    Pet() {}

    /**
     * Constructs a new instance of {@link Pet}.
     *
     * @param id identifier of the pet.
     * @param name name of the pet.
     * @param owner person who owns the pet.
     */
    public Pet(int id, String name, Person owner) {
        this.id = id;
        this.setName(name);
        this.setOwner(owner);
    }

    /**
     * Returns the identifier of the pet.
     *
     * @return the identifier of the pet.
     */
    public int getId() {
        return id;
    }

    /**
     * Returns the name of the pet.
     *
     * @return the name of the pet.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name of this person.
     *
     * @param name the new name of the person.
     * @throws NullPointerException if the {@code name} is {@code null}.
     */
    public void setName(String name) {
        this.name = requireNonNull(name, "Name can't be null");
    }
    /**
     * Returns the owner of the pet.
     *
     * @return the owner of the pet.
     */
    public Person getOwner() {
        return owner;
    }

    /**
     * Set the owner of this pet.
     *
     * @param owner the owner of the pet.
     * @throws NullPointerException if the {@code owner} is {@code null}.
     */
    public void setOwner(Person owner) {
        this.owner = requireNonNull(owner, "Owner can't be a null reference");
    }
}
