package es.uvigo.esei.daa.dataset;

import es.uvigo.esei.daa.entities.Pet;

import java.util.Arrays;
import java.util.function.Predicate;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

public final class PetDataset {
	private PetDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Pet1", 1),
			new Pet(2, "Pet2", 1),
			new Pet(3, "Pet3", 1),
			new Pet(4, "Pet4", 1),
			new Pet(5, "Pet5", 1),
			new Pet(6, "Pet6", 1),
			new Pet(7, "Pet7", 1),
			new Pet(8, "Pet8", 1),
			new Pet(9, "Pet9", 2),
			new Pet(10, "Pet McPetface", 2)
		};
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = Pet ->
			binarySearch(ids, Pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet Pet(int id) {
		return stream(pets())
			.filter(Pet -> Pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return Pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Jane", 1);
	}
	
	public static String newName() {
		return "Pettity Pet";
	}
	
	public static String newOwnerID() {
		return "1";
	}

	//We add the last pet o the first user, always for testing purposes
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), 1);
	}
}
