package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * Entity that represents a pet from a int
 *
 * Created by cya on 2/9/17.
 */
public class Pet {
    private int id;
    private String name;
    private int ownerID;

    // Constructor needed for the JSON conversion
    Pet() {}

    /**
     * Constructs a new instance of {@link Pet}.
     *
     * @param id identifier of the pet.
     * @param name name of the pet.
     * @param ownerID int who owns the pet.
     */
    public Pet(int id, String name, int ownerID) {
        this.id = id;
        this.setName(name);
        this.setownerID(ownerID);
    }


    /**
     * Returns the identifier of the pet.
     *
     * @return the identifier of the pet.
     */
    public int getId() {
        return id;
    }

    /**
     * Returns the name of the pet.
     *
     * @return the name of the pet.
     */
    public String getName() {
        return name;
    }

    /**
     * Set the name of this int.
     *
     * @param name the new name of the int.
     * @throws NullPointerException if the {@code name} is {@code null}.
     */
    public void setName(String name) {
        this.name = requireNonNull(name, "Name can't be null");
    }
    /**
     * Returns the ownerID of the pet.
     *
     * @return the ownerID of the pet.
     */
    public int getownerID() {
        return ownerID;
    }

    /**
     * Set the ownerID of this pet.
     *
     * @param ownerID the ownerID of the pet.
     * @throws NullPointerException if the {@code ownerID} is {@code null}.
     */
    public void setownerID(int ownerID) {
        this.ownerID = requireNonNull(ownerID, "ownerID can't be a null reference");
    }

    /* NOT UNITESTED
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Pet))
            return false;
        Pet other = (Pet) obj;
        if (id != other.id)
            return false;
        return true;
    }
    */
}
