package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	@Test
	public void testPetIntStringPerson() {
		final int id = 1;
		final String name = "Micifu";
		final int ownerId = 1;
		final String ownerName = "Paco";
		final String ownerSurname = "Martinez";
		
		final Person owner = new Person(ownerId, ownerName, ownerSurname);
		
		final Pet pet = new Pet(id, name, owner);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringPersonNullName() {
		final Person owner = new Person(1, "Paco", "Martinez");
		new Pet(1, null, owner);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringPersonNullOwner() {
		new Pet(1, "Micifu", null);
	}
	
	@Test
	public void testSetName() {
		final int id = 1;
		final Person owner = new Person(1, "Paco", "Martinez");
		
		final Pet pet = new Pet(id, "Micifu", owner);
		pet.setName("Tobi");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Tobi")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Micifu", new Person(1, "Paco", "Martinez"));
		pet.setName(null);
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetOwner() {
		final int id = 1;
		final String name = "Micifu";
		final Person owner = new Person(1, "Paco", "Martinez");
		
		final Pet pet = new Pet(id, name, new Person(1, "Ana", "Lola"));
		pet.setOwner(owner);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));	
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetOwnerNull() {
		final Pet pet = new Pet(1, "Micifu", new Person(1, "Paco", "Martinez"));
		pet.setOwner(null);
	}
	
	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Micifu", new Person(1, "Paco", "Martinez"));
		final Pet petB = new Pet(1, "Tobi", new Person(2, "Ana", "Ana"));
		
		assertTrue(petA.equals(petB));
	}
	
	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "owner")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
