var PetsView = (function(){
	var dao;
	var self;
	
	var formId = 'pets-form';
	var listId = 'pets-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetsView(petsDao, modalId, title){
		dao = petsDao;
		self = this;
		
		$('#' + modalId + '-body').empty();
		$('#' + modalId + '-title').empty();
		
		insertPetsForm($('#' + modalId + '-body'));
		insertPetsList($('#' + modalId + '-body'));
		insertModalTitle($('#' + modalId + '-title'), title);
		
		this.init = function(){
			dao.listPets(function(pets){
				$.each(pets, function(key, pet){
					appendToTable(pet);
				});
			},
			function(){
				alert("No ha sido posible acceder al listado de mascotas");
			});
			
			$(formQuery).submit(function(event){
				var pet = self.getPetInForm();
				
				if(self.isEditing()){
					dao.modifyPet(pet,
						function(pet) {
							$('#pet-' + pet.id + ' td.name').text(pet.name);
							self.resetForm();
						}
					);
				} else {
					dao.addPet(pet, 
						function(pet){
							appendToTable(pet);
							self.resetForm();
						}
					);
				}
				
				return false;
			});
			
			$('#btnClearPet').click(this.resetForm);
			
		};
		
		this.getPetInForm = function(){
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
				'name': form.find('input[name="name"]').val()
			}
		};
		
		this.resetForm = function(){
			$(formQuery)[0].reset();
			$(formQuery + 'input[name="id"').val('');
			$('#btnSubmitPet').val('Crear');
		};
		
		this.deletePet = function(id){
			if(confirm('Está apunto de eliminar una mascoto. ¿Está seguro de que desea continuar?')){
				dao.deletePet(id,
					function(){
						$('tr#pet-' + id).remove();
					}
				);
			}
		};
		
		this.editPet = function(id){
			var row = $('#pet-' + id);
			
			if(row !== undefined){
				var form = $(formQuery);
				
				form.find('input[name="id"]').val(id);
				form.find('input[name="name"]').val(row.find('td.name').text());
				
				$('input#btnSubmitPet').val('Modificar');
			}
		};
		
		this.isEditing = function(){
			return $(formQuery + ' input[name="id"]').val() != "";
		};
		
	};
	
	var getPersonInForm = function(){
		var form = $(formQuery);
		return {
			'id' : form.find('input[name="id"]').val(),
			'name' : form.find('input[name="name"]').val(),
		};
	};
	
	var insertPetsForm = function(parent) {
		parent.append(
			'<form id="' + formId + '">\
				<input name="id" type="hidden" value=""/>\
				<div class="row">\
					<div>\
						<input name="name" type="text" value="" placeholder="Nombre" class="form-control" required/>\
					</div>\
					<div>\
						<input id="btnSubmitPet" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClearPet" type="reset" value="Limpiar" class="btn" />\
					</div>\
				</div>\
			</form>'
		);
	};
	
	var insertPetsList = function(parent){
		parent.append(
			'<table id="' + listId + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col">Nombre</th>\
						<th>&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};
	
	var createPetRow = function(pet){
		return '<tr id="pet-'+ pet.id +'" class="row">\
			<td class="name col">' + pet.name + '</td>\
			<td>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
				<a class="edit btn btn-primary" href="#">Editar</a>\
			</td>\
		</tr>';
	};
	
	var addRowListeners = function(pet){
		$('#pet-' + pet.id + ' a.delete').click(function(){
			self.deletePet(pet.id);
		});
		
		$('#pet-' + pet.id + ' a.edit').click(function(){
			self.editPet(pet.id);
		});
	};
	
	var appendToTable = function(pet){
		$(listQuery + ' > tbody:last').append(createPetRow(pet));
		addRowListeners(pet);
	};
	
	var insertModalTitle = function(parent, title){
		parent.append(
				'Mascotas de ' + title
		);
	};
	
	return PetsView;
})();