package es.uvigo.esei.daa.rest;

import javax.ws.rs.DELETE;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.daa.dao.DAOException;
import es.uvigo.esei.daa.dao.PeopleDAO;
import es.uvigo.esei.daa.dao.PetsDAO;
import es.uvigo.esei.daa.entities.Pet;


@Path("/people/{idOwner}/pets")
@Produces(MediaType.APPLICATION_JSON)
public class PetsResource {
	
	private final PetsDAO dao;
	private final PeopleDAO peopleDao;
	
	public PetsResource() {
		this(new PetsDAO(), new PeopleDAO());
	}
	
	PetsResource(PetsDAO dao, PeopleDAO peopleDao) {
		this.dao = dao;
		this.peopleDao = peopleDao;
	}
	
	@GET
	public Response listPets(@PathParam("idOwner") int owner_id) {
		try {
			return Response.ok(this.dao.listByOwnerId(owner_id)).build();
		} catch(DAOException e) {
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	@GET
	@Path("/{id}")
	public Response get(@PathParam("id") int id) {
		try {
			final Pet pet = this.dao.get(id);
			return Response.ok(pet).build();
		} catch(IllegalArgumentException e) {
			return Response.status(Response.Status.BAD_REQUEST).entity(e.getMessage()).build();
		} catch(DAOException e) {
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	@POST
	public Response add(@FormParam("name") String name, @PathParam("idOwner") int idOwner) {
		try {
			final Pet newPet = this.dao.add(name, idOwner);
			return Response.ok(newPet).build();
		} catch(IllegalArgumentException e) {
			return Response.status(Response.Status.BAD_REQUEST).entity(e.getMessage()).build();
		} catch(DAOException e) {
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	@PUT
	@Path("/{id}")
	public Response modify(@PathParam("id") int id, @FormParam("name") String name, @PathParam("idOwner") int idOwner) {
		try {
			final Pet modifiedPet = new Pet(id, name, peopleDao.get(idOwner));
			this.dao.modify(modifiedPet);
			return Response.ok(modifiedPet).build();
		} catch(NullPointerException npe) {
			final String message = String.format("Invalid data for pet (name: %s, owner: %d", name, idOwner);
			return Response.status(Response.Status.BAD_REQUEST).entity(message).build();
		} catch (IllegalArgumentException iae) {
			return Response.status(Response.Status.BAD_REQUEST).entity(iae.getMessage()).build();
		} catch (DAOException e) {
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
	
	@DELETE
	@Path("/{id}")
	public Response delete(@PathParam("id") int id) {
		try {
			this.dao.delete(id);
			return Response.ok(id).build();
		} catch(IllegalArgumentException iae) {
			return Response.status(Response.Status.BAD_REQUEST).entity(iae.getMessage()).build();
		} catch (DAOException e) {
			return Response.serverError().entity(e.getMessage()).build();
		}
	}
}
