import { Component, ElementRef, ViewChild } from '@angular/core';
import { AnnotatorComponent } from "../annotator/annotator.component";

@Component({
  selector: 'amc-annotation',
  standalone: true,
  imports: [AnnotatorComponent],
  templateUrl: './annotation.component.html',
  styleUrl: './annotation.component.scss'
})
export class AnnotationComponent {
  @ViewChild("annotator", { static: true })
  private annotator!: AnnotatorComponent;

  public onUploadImage(event: DragEvent): void {
    console.log(this.annotator);

    event.preventDefault();

    const file = event.dataTransfer?.files[0];
    
    if (file && file.type.startsWith("image/")) {
      console.log(file);
      
      const reader = new FileReader();

      reader.onload = (event: ProgressEvent<FileReader>) => {
        console.log("Read");
        const image = new Image();

        image.onload = (event: Event) => {
          this.annotator.changeImage(image);
        }

        if (typeof(event.target?.result) === "string") {
          image.src = event.target.result;
        }
      };

      reader.readAsDataURL(file);
    } else {
      alert("Only images are supported");
    }
  }

  public onDragOver(event: DragEvent): void {
    event.preventDefault();
    console.log(typeof (event));
  }

}
