var PetView = (function() {
	var dao;
	
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
	
	var formId = 'pet-form';
	var listId = 'pet-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetView(petsDao, formContainerId, listContainerId) {
		dao = petsDao;
		self = this;
		
		insertPetForm($('#' + formContainerId));
		insertPetList($('#' + listContainerId));
		
		this.init = function() {
			dao.listPet(function(pet) {
				$.each(pet, function(key, pet) {
					appendToTable(pet);
				});
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var pet = self.getPetInForm();
				
				if (self.isEditing()) {
					dao.modifyPet(pet,
						function(pet) {
							$('#pet-' + pet.idPet + ' td.name').text(pet.name);
							$('#pet-' + pet.idPet + ' td.idOwner').text(pet.idOwner);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPet(pet,
						function(pet) {
							appendToTable(pet);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
		};

		this.getPetInForm = function() {
			var form = $(formQuery);
			return {
				'idPet': form.find('input[name="idPet"]').val(),
				'name': form.find('input[name="name"]').val(),
				'idOwner': form.find('input[name="idOwner"]').val()
			};
		};

		this.getPetInRow = function(idPet) {
			var row = $('#pet-' + idPet);

			if (row !== undefined) {
				return {
					'idPet': idPet,
					'name': row.find('td.name').text(),
					'idOwner': row.find('td.idOwner').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editPet = function(idPet) {
			var row = $('#pet-' + idPet);

			if (row !== undefined) {
				var form = $(formQuery);
				
				form.find('input[name="idPet"]').val(idPet);
				form.find('input[name="name"]').val(row.find('td.name').text());
				form.find('input[name="idOwner"]').val(row.find('td.idOwner').text());
				
				$('input#btnSubmit').val('Modificar');
			}
		};
		
		this.deletePet = function(idPet) {
			if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
				dao.deletePet(id,
					function() {
						$('tr#pet-' + idPet).remove();
					},
					showErrorMessage
				);
			}
		};

		this.isEditing = function() {
			return $(formQuery + ' input[name="idPet"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="idPet"]').val('');
			$('#btnSubmit').val('Crear');
		};
	};
	
	var insertPetList = function(parent) {
		parent.append(
			'<table idPet="' + listIdPet + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col-sm-4">Nombre</th>\
						<th class="col-sm-5">Dueño</th>\
						<th class="col-sm-3">&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};

	var insertPetForm = function(parent) {
		parent.append(
			'<form idPet="' + formIdPet + '" class="mb-5 mb-10">\
				<input name="idPet" type="hidden" value=""/>\
				<div class="row">\
					<div class="col-sm-4">\
						<input name="name" type="text" value="" placeholder="Nombre" class="form-control" required/>\
					</div>\
					<div class="col-sm-5">\
						<input name="idOwner" type="text" value="" placeholder="Dueño" class="form-control" required/>\
					</div>\
					<div class="col-sm-3">\
						<input id="btnSubmit" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClear" type="reset" value="Limpiar" class="btn" />\
					</div>\
				</div>\
			</form>'
		);
	};

	var createPetRow = function(pet) {
		return '<tr id="pet-'+ pet.idPet +'" class="row">\
			<td class="name col-sm-4">' + pet.name + '</td>\
			<td class="idOwner col-sm-5">' + pet.idOwner + '</td>\
			<td class="col-sm-3">\
				<a class="edit btn btn-primary" href="#">Editar</a>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
			</td>\
		</tr>';
	};

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	};

	var addRowListeners = function(pet) {
		$('#pet-' + pet.idPet + ' a.edit').click(function() {
			self.editPet(pet.idPet);
		});
		
		$('#pet-' + pet.idPet + ' a.delete').click(function() {
			self.deletePet(pet.idPet);
		});
	};

	var appendToTable = function(pet) {
		$(listQuery + ' > tbody:last')
			.append(createPetRow(pet));
		addRowListeners(pet);
	};
	
	return PetView;
})();
