package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {
	private int idPet;
	private String name;
	private int idOwner;
	
	
	Pet() {}
	
	public Pet(int idPet, String name, int idOwner) {
		this.idPet = idPet;
		this.setName(name);
		this.setOwner(idOwner);
	}
	
	public int getIdPet() {
		return idPet;
	}
	
	public String getName() {
		return name;
	}
	
	public int getIdOwner() {
		return idOwner;
	}

	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}

	public void setOwner(int idOwner) {
		this.idOwner = idOwner;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + idPet;
		return result;
	}
	
	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (idPet != other.idPet)
			return false;
		return true;
	}
	
	
}
