package es.uvigo.esei.daa.rest;

import java.util.logging.Level;

import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;

import es.uvigo.esei.daa.dao.DAOException;
import es.uvigo.esei.daa.entities.Person;

@Path("/pets")
@Produces(MediaType.APPLICATION_JSON)
public class PetResource {
	
	@GET
	@Path("/{idPet}")
	public Response get(@PathParam("idPet") int idPet) {
		try {
			final Person person = this.dao.get(id);
			
			return Response.ok(person).build();
		} catch (IllegalArgumentException iae) {
			LOG.log(Level.FINE, "Invalid person id in get method", iae);
			
			return Response.status(Response.Status.BAD_REQUEST)
				.entity(iae.getMessage())
			.build();
		} catch (DAOException e) {
			LOG.log(Level.SEVERE, "Error getting a person", e);
			
			return Response.serverError()
				.entity(e.getMessage())
			.build();
		}
	}

}
