package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	
	@Test
	public void testIntStringString() {
		
		final int id = 1;
		final String name = "cocodrilo";
		final int idOwner = 4;
		
		final Pet pet = new Pet(id,name,idOwner);
		
		assertThat(pet.getId(), equalTo(id));
		assertThat(pet.getName(), equalTo(name));
		assertThat(pet.getIdOwner(), equalTo(idOwner));
		
		
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntNullName() {
		new Pet(1, null, 3);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int idOwner = 5;
		
		final Pet pet = new Pet(id, "gato", idOwner);
		pet.setName("manoplas");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("manoplas")));
		assertThat(pet.getIdOwner(), is(equalTo(idOwner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet person = new Pet(1, "Coco", 3);
		
		person.setName(null);
	}

	@Test
	public void testnewOwner() {
		final int id = 1;
		final String name = "manoplas";
		
		final Pet pet = new Pet(id, name, 2);
		pet.setOwner(4);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getIdOwner(), is(equalTo(4)));
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 2);
		final Pet petB = new Pet(1, "Name B", 3);
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "idOwner")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}

}
