package es.uvigo.esei.daa.dataset;

import es.uvigo.esei.daa.entities.Pet;

import java.util.Arrays;
import java.util.function.Predicate;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

public final class PetDataset {
	private PetDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, 1, "Dog", "Dog"),
			new Pet(2, 1, "Perro", "Dog"),
			new Pet(3, 1, "Per","Dog"),
			new Pet(4, 1, "Soso","Dog"),
			new Pet(5, 1, "Lino","Dog"),
			new Pet(6, 1, "Lar","Dog"),
			new Pet(7, 1, "Raul","Dog"),
			new Pet(8, 1, "Man","Dog"),
			new Pet(9, 1, "Justa","Dog"),
			new Pet(10, 1, "Lita","Dog")
		};
	}
	
	public static Pet[] petWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = Pet ->
			binarySearch(ids, Pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet Pet(int id) {
		return stream(pets())
			.filter(Pet -> Pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return Pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), 1,"Dogu", "Smith");
	}
	
	public static String newName() {
		return "Jo";
	}
	
	public static String newEspecie() {
		return "Do";
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1,1, newName(), newEspecie());
	}
}
