package es.uvigo.esei.daa.entities;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;
import org.junit.Test;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

public class PetUnitTest {
	@Test
	public void testPetIntStringString() {
		final int id = 1;
		final int personId = 1;
		final String name = "Jo";
		final String surname = "Do";
		
		final Pet pet = new Pet(id, personId,  name, surname);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getPersonId(), is(equalTo(personId)));
		assertThat(pet.getNombre(), is(equalTo(name)));
		assertThat(pet.getEspecie(), is(equalTo(surname)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringNullName() {
		new Pet(1, 1, null, "Do");
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringNullSurname() {
		new Pet(1,1, "Jo", null);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int personId = 1;
		final String surname = "Do";
		
		final Pet pet = new Pet(id, personId,  "Jo", surname);
		pet.setNombre("Ricolino");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getPersonId(), is(equalTo(personId)));
		assertThat(pet.getNombre(), is(equalTo("Ricolino")));
		assertThat(pet.getEspecie(), is(equalTo(surname)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, 1, "Jo", "Do");
		
		pet.setNombre(null);
	}

	@Test
	public void testSetEspecie() {
		final int id = 1;
		final int personId = 1;
		final String name = "Do";

		final Pet pet = new Pet(id, personId, name, "Do");
		pet.setEspecie("Dogo");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getNombre(), is(equalTo(name)));
		assertThat(pet.getEspecie(), is(equalTo("Dogo")));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullEspecie() {
		final Pet pet = new Pet(1, 1, "Jo", "Do");
		
		pet.setEspecie(null);
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1,1,  "Nombre A", "Especie A");
		final Pet petB = new Pet(1,1,  "Nombre B", "Especie B");
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("nombre", "especie")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
