var PetView = (function() {
	var dao;
	
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
    var url = window.location.href;
	var personId;
	
	var formId = 'pet-form';
	var listId = 'pet-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetView(petDao, formContainerId, listContainerId) {
		dao = petDao;
		self = this;
        personId= url.substring(url.lastIndexOf('?') + 1);

		insertPetForm($('#' + formContainerId));
		insertPetList($('#' + listContainerId));
		
		this.init = function() {
            var pet = self.getPetInForm();

			dao.listPet(function(pet)
			{
				$.each(pet, function(key, pet) {
					appendToTable(pet);
				});
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var pet = self.getPetInForm();
				
				if (self.isEditing()) {
					dao.modifyPet(pet,
						function(pet) {
                            $('#pet-' + pet.id + ' td.personId').text(pet.personId);
							$('#pet-' + pet.id + ' td.nombre').text(pet.nombre);
							$('#pet-' + pet.id + ' td.especie').text(pet.especie);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPet(pet,
						function(pet) {
							appendToTable(pet);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
		};

		this.getPetInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
                'personId': form.find('input[name="personId"]').val(),
				'nombre': form.find('input[name="nombre"]').val(),
				'especie': form.find('input[name="especie"]').val()
			};
		};

		this.getPetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'nombre': row.find('td.nombre').text(),
					'especie': row.find('td.especie').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editpet = function(id) {
			var row = $('#pet-' + id);

			console.log(row);
			if (row !== undefined) {
				var form = $(formQuery);
				console.log(form);
				console.log(row.find('td.nombre').text());
				console.log(row.find('td.especie').text());
				
				form.find('input[name="id"]').val(id);
				form.find('input[name="nombre"]').val(row.find('td.nombre').text());
				form.find('input[name="especie"]').val(row.find('td.especie').text());
			}
		}

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
	}
	
	var insertPetList = function(parent) {
		parent.append(
			'<table id="' + listId + '">\
				<tr>\
					<th>Nombre</th>\
					<th>Especie</th>\
					<th></th>\
					<th></th>\
				</tr>\
			</table>'
		);
	}

	var insertPetForm = function(parent) {
		parent.append(
			'<form id="' + formId + '">\
				<input name="id" type="hidden" value=""/>\
				<input name="personId" type="hidden" value="'+ personId +' "/>\
				<input name="nombre" type="text" value="" />\
				<input name="especie" type="text" value=""/>\
				<input id="btnSubmit" type="submit" value="Create"/>\
				<input id="btnClear" type="reset" value="Limpiar"/>\
			</form>'
		);
	}

	var createpetRow = function(pet) {
		if(pet.personId == personId) {
            return '<tr id="pet-' + pet.id + '">\
			<td class="nombre">' + pet.nombre + '</td>\
			<td class="especie">' + pet.especie + '</td>\
			<td>\
				<a class="edit" href="#">Edit</a>\
			</td>\
			<td>\
				<a class="delete" href="#">Delete</a>\
			</td>\
		</td>';
        }
	}

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	}

	var addRowListeners = function(pet) {
		$('#pet-' + pet.id + ' a.edit').click(function() {
			self.editpet(pet.id);
			$('input#btnSubmit').val('Modificar');
		});
		
		$('#pet-' + pet.id + ' a.delete').click(function() {
			if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
				dao.deletePet(pet.id,
					function() {
						$('tr#pet-' + pet.id).remove();
					},
					showErrorMessage
				);
			}
		});
	}

	var appendToTable = function(pet) {
		$(listQuery + ' > tbody:last')
			.append(createpetRow(pet));
		addRowListeners(pet);
	}
	
	return PetView;
})();
