package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * Entidad que representa Mascota
 *
 * Created by Luis Francisco on 23/02/2017.
 */
public class Pet
{
    private int id;
    private int personId;
    private String nombre;
    private String especie;

    // Constructor needed for the JSON conversion
    Pet() {}

    /**
     * Constructs a new instance of {@link Pet}.
     *
     * @param id identificador de la mascota.
     * @param nombre nombre de la mascota.
     * @param especie tipo de especie de la mascota.
     */
    public Pet(int id, int personId, String nombre, String especie)
    {
        this.personId = personId;
        this.id = id;
        this.setNombre(nombre);
        this.setEspecie(especie);
    }

    /**
     * Devuelve el identificador de la mascota.
     *
     * @return identificador de la mascota.
     */
    public int getId()
    {
        return id;
    }

    /**
     * Devuelve el identificador del dueño de la mascota.
     *
     * @return identificador del dueño de la mascota.
     */
    public int getPersonId()
    {
        return personId;
    }

    /**
     * Devuelve el nombre de la mascota.
     *
     * @return nombre de la mascota.
     */
    public String getNombre()
    {
        return nombre;
    }

    /**
     * Modifica el nombre de la mascota.
     *
     * @param nombre nuevo nombre de la mascota.
     * @throws NullPointerException if the {@code name} is {@code null}.
     */
    public void setNombre(String nombre)
    {
        this.nombre = requireNonNull(nombre, "Name can't be null");
    }

    /**
     * Devuelve el especie de la mascota.
     *
     * @return especie de la mascota.
     */
    public String getEspecie()
    {
        return especie;
    }

    /**
     * Modifica la especie de la mascota.
     *
     * @param especie especie de la mascota.
     * @throws NullPointerException if the {@code name} is {@code null}.
     */
    public void setEspecie(String especie)
    {
        this.especie = requireNonNull(especie, "Specie can't be null");
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (!(obj instanceof Pet))
            return false;
        Pet other = (Pet) obj;
        if (id != other.id)
            return false;
        return true;
    }
}
