package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.*;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {

	@Test
	public void testPetIntStringIntString() {
		final int id = 1;
		final String name = "John";
		final int owner = 1;
		final String typeOfAnimal = "Dog";
		
		final Pet pet = new Pet(id, name, owner,typeOfAnimal);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getTypeOfAnimal(), is(equalTo(typeOfAnimal)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntStringNullName() {
		new Pet(1, null, 1, "Dog");
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntStringNullOwner() {
		new Pet(1, "John", null, "Dog");
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntStringNullTypeOfAnimal() {
		new Pet(1, "John", null, null);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int owner = 1;
		final String typeOfAnimal = "Dog";
		
		final Pet pet = new Pet(id, "Juan", owner, typeOfAnimal);
		pet.setName("John");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("John")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getTypeOfAnimal(), is(equalTo(typeOfAnimal)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "John", 1,"Dog");
		
		pet.setName(null);
	}

	@Test
	public void testSetTypeOfAnimal() {
		final int id = 1;
		final int owner=1;
		final String name = "John";
		
		final Pet pet = new Pet(id, name, owner,"Cat");
		pet.setTypeOfAnimal("Dog");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
		assertThat(pet.getTypeOfAnimal(), is(equalTo("Dog")));
		
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullTypeOfAnimal() {
		final Pet pet = new Pet(1, "John", 1,"Dog");
		
		pet.setTypeOfAnimal(null);
	}
	
	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 1, "Type Of Animal A");
		final Pet petB = new Pet(1, "Name B", 1, "Type Of Animal B");
		
		assertTrue(petA.equals(petB));
	}

	@Test
    public void testEqualsHashcode() {
        EqualsVerifier.forClass(Pet.class)
            .withIgnoredFields("name", "owner", "typeOfAnimal")
            .suppress(Warning.STRICT_INHERITANCE)
            .suppress(Warning.NONFINAL_FIELDS)
        .verify();
    }

}
