package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * An entity that represents a person.
 * 
 * @author Miguel Reboiro Jato
 */
public class Pet {
	private int id;
	private String name;
    private int owner;
	private String typeOfAnimal;
	
	// Constructor needed for the JSON conversion
	Pet() {}
	
	/**
	 * Constructs a new instance of {@link Pet}.
	 *
	 * @param id identifier of the pet.
	 * @param name name of the pet.
	 * @param owner owner of the pet.
	 */
	public Pet(int id, String name, Integer owner, String typeOfAnimal) {
		this.id = id;
		this.setName(name);
		this.owner=owner;
        this.setTypeOfAnimal(typeOfAnimal);
	}
	
	/**
	 * Returns the identifier of the person.
	 * 
	 * @return the identifier of the person.
	 */
	public int getId() {
		return id;
	}

    /**
	 * Returns the name of the pet.
	 * 
	 * @return the name of the pet.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Returns the owner of the pet.
	 * 
	 * @return the owner of the pet.
	 */
	public int getOwner() {
		return owner;
	}

    /**
	 * Returns the type of animal.
	 * 
	 * @return the type of animal.
	 */
	public String getTypeOfAnimal() {
		return typeOfAnimal;
	}


	/**
	 * Set the name of this pet.
	 * 
	 * @param name the new name of the pet.
	 * @throws NullPointerException if the {@code name} is {@code null}.
	 */
	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}


	public void setOwner(Integer owner) {
		this.owner = requireNonNull(owner, "Owner can't be null");
	}


    /**
	 * Set the type of animal of this pet.
	 * 
	 * @param typeOfAnimal the new type of the pet.
	 * @throws NullPointerException if the {@code typeOfAnimal} is {@code null}.
	 */
	public void setTypeOfAnimal(String typeOfAnimal) {
		this.typeOfAnimal = requireNonNull(typeOfAnimal, "Type of animal can't be null");
	}

    

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
}
