/*
 * DAA Example
 *
 * Copyright (C) 2019 - Miguel Reboiro-Jato.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {PetModel} from '../../models/pet.model';
import {PetsService} from '../../services/pets.service';
import { PersonModel } from 'src/app/modules/people/models/person.model';
import { PeopleService } from 'src/app/modules/people/services/people.service';


@Component({
  selector: 'app-pets-list',
  templateUrl: './pets-list.component.html',
  styleUrls: ['./pets-list.component.scss']
})
export class PetsListComponent {

  @Input()
  public pets: PetModel[] = [];
  public people: PersonModel[] = [];
  

  @Output()
  public readonly edit: EventEmitter<PetModel>;
  @Output()
  public readonly delete: EventEmitter<PetModel>;

  public constructor(private readonly peopleService: PeopleService
    ) {
    this.edit = new EventEmitter<PetModel>();
    this.delete = new EventEmitter<PetModel>();
    this.peopleService.list()
      .subscribe(people => this.people = people);
  }

  

  public onEdit(pets: PetModel) {
    this.edit.emit(pets);
  }

  public onDelete(pets: PetModel) {
    this.delete.emit(pets);
  }

  public owner(idPersona: number){

    var toret = "" ;

    this.people.forEach(element => {
      if(element.id==idPersona){
        toret=element.name+" ";
        toret+=element.surname;

      }
    });
   
    return toret;
  }

}
