/*
 * DAA Example
 *
 * Copyright (C) 2019 - Miguel Reboiro-Jato.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {PetModel} from '../../models/pet.model';
import { PersonModel } from 'src/app/modules/people/models/person.model';
import { PeopleService } from 'src/app/modules/people/services/people.service';

@Component({
  selector: 'app-pets-form',
  templateUrl: './pets-form.component.html',
  styleUrls: ['./pets-form.component.scss']
})
export class PetsFormComponent {
  public activePet: PetModel;
  public people: PersonModel[] = [];

  @Output()
  public readonly modify: EventEmitter<PetModel>;
  @Output()
  public readonly clean: EventEmitter<never>;

  public name: string;
  public owner: number;
  public typeOfAnimal: string;

  public constructor(private readonly peopleService: PeopleService) {
    this.modify = new EventEmitter<PetModel>();
    this.clean = new EventEmitter<never>();
    this.peopleService.list()
    .subscribe(people => this.people = people);
  }

  @Input()
  public set pet(pet: PetModel) {
    this.activePet = pet;
    this.name = pet.name;
    this.owner = pet.owner;
    this.typeOfAnimal = pet.typeOfAnimal;
  }

  public get pet(): PetModel {
    return this.activePet;
  }

  public onModify() {
    console.log(this.typeOfAnimal);
    this.modify.emit({
      id: this.pet.id,
      name: this.name,
      owner: this.owner,
      typeOfAnimal: this.typeOfAnimal
    });
  }

  public onClean() {
    this.clean.emit();
  }
}
