package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;
import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.function.Predicate;

import org.junit.Test;

import es.uvigo.esei.daa.entities.Pet;

public class PetsDataset {
private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Antón", 1,"Perro"),
			new Pet(2, "Ana", 2,"Gato"),
			new Pet(3, "Manuel", 3,"Cobaya"),
			new Pet(4, "María", 4,"Zorro"),
			new Pet(5, "Lorenzo", 5,"Rata"),
			new Pet(6, "Laura", 6,"Pitón"),
			new Pet(7, "Perico", 7,"Langostino"),
			new Pet(8, "Patricia", 8,"Avutarda"),
			new Pet(9, "Julia", 9,"Tucán"),
			new Pet(10, "Juan", 10,"Tigre")
		};
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Jane", 1,"Zebra");
	}
	
	public static String newName() {
		return "John";
	}
	
	public static Integer newOwner() {
		return 1;
	}
	
	public static String newTypeOfAnimal() {
		return "Perro";
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newOwner(), newTypeOfAnimal());
	}

}
