/*
 * DAA Example
 *
 * Copyright (C) 2019 - Javier Quintas Bergantiño.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import {Injectable, Inject} from '@angular/core';
import {HttpClient, HttpHeaders, HttpParams} from '@angular/common/http';
import {environment} from '../../../../environments/environment';
import {Observable} from 'rxjs';
import {PetModel} from '../models/pet.model';

@Injectable({
    providedIn: 'root'
})
export class PetsService{

    public constructor(private readonly http: HttpClient) { }

    public list(): Observable<PetModel[]> {
        return this.http.get<PetModel[]>(`${environment.restApi}/pets`);
    }

    public create(pet: PetModel): Observable<PetModel> {
        const data = new HttpParams()
        .set('name', pet.name)
        .set('animalType', pet.animalType)
        .set('owner_id', pet.ownerId.toString());

        return this.http.post<PetModel>(`${environment.restApi}/pets`, data);
    }

    public modify(pet: PetModel): Observable<PetModel> {
        const data = new HttpParams()
        .set('name', pet.name)
        .set('animalType', pet.animalType)
        .set('owner_id', pet.ownerId.toString());

        return this.http.put<PetModel>(`${environment.restApi}/pets/${pet.id}`, data);
    }

    public delete(pet: PetModel): Observable<number> {
        return this.http.delete<number>(`${environment.restApi}/pets/${pet.id}`);
    }
}