/*
 * DAA Example
 *
 * Copyright (C) 2019 - Miguel Reboiro-Jato.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {PetModel} from '../../models/pet.model';
import {PetsService} from '../../services/pets.service';

@Component({
  selector: 'app-pets-list',
  templateUrl: './pets-list.component.html',
  styleUrls: ['./pets-list.component.scss']
})
export class PetsListComponent {

  @Input()
  public pets: PetModel[] = [];

  @Output()
  public readonly edit: EventEmitter<PetModel>;
  @Output()
  public readonly delete: EventEmitter<PetModel>;

  public constructor() {
    this.edit = new EventEmitter<PetModel>();
    this.delete = new EventEmitter<PetModel>();
  }

  public onEdit(pet: PetModel) {
    this.edit.emit(pet);
  }

  public onDelete(pet: PetModel) {
    this.delete.emit(pet);
  }
}
