package es.uvigo.esei.daa.entities;

import static org.junit.Assert.*;
import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {

	@Test
	public void testPetIntStringStringInt() {
		final int id = 1;
		final String name = "Tafi";
		final String animalType = "Perro";
		final int owner_id = 1;
		
		final Pet pet = new Pet(id, name, animalType, owner_id);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getAnimalType(), is(equalTo(animalType)));
		assertThat(pet.getOwnerId(), is(equalTo(owner_id)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testPersonIntStringStringIntNullName() {
		new Pet(1, null, "Perro", 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPersonIntStringStringIntNullAnimalType() {
		new Pet(1, "Tafi", null, 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPersonIntStringStringNullOwnerId() {
		Integer own = null;
		new Pet(1, "Tafi", "Perro", own);
	}
	
	@Test
	public void testSetName() {
		final int id = 1;
		final String animalType = "Perro";
		
		final Pet pet = new Pet(id, "Tafi", animalType, 1);
		pet.setName("Sultan");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Sultan")));
		assertThat(pet.getAnimalType(), is(equalTo(animalType)));
		assertThat(pet.getOwnerId(), is(equalTo(1)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Tafi", "Perro", 1);
		
		pet.setName(null);
	}
	
	@Test
	public void testSetAnimalType() {
		final int id = 1;
		final String name = "Tafi";
		
		final Pet pet = new Pet(id, name, "Perro", 1);
		pet.setAnimalType("Elefante");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getAnimalType(), is(equalTo("Elefante")));
		assertThat(pet.getOwnerId(), is(equalTo(1)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testSetNullAnimalType() {
		final Pet pet = new Pet(1, "Tafi", "Perro", 1);
		
		pet.setAnimalType(null);
	}
	
	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", "AnimalType A", 1);
		final Pet petB = new Pet(1, "Name B", "AnimalType B", 1);
		
		assertTrue(petA.equals(petB));
	}
	
	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "animalType", "ownerId")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
	
}
