package es.uvigo.esei.daa.dataset;

import static org.junit.Assert.*;

import java.util.Arrays;
import java.util.function.Predicate;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import org.junit.Test;

import es.uvigo.esei.daa.entities.Pet;

public class PetsDataset {
	private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Tafi", "Perro", 1),
			new Pet(2, "Tafi1", "Perro1", 1),
			new Pet(3, "Tafi2", "Perro2", 1),
			new Pet(4, "Tafi3", "Perro3", 1),
			new Pet(5, "Tafi4", "Perro4", 1),
			new Pet(6, "Tafi5", "Perro5", 1)
		};
	}

	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}

	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 1234;
	}
	
	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Tafi10", "Perro10", 1);
	}
	
	public static String newName() {
		return "Tafi7";
	}
	
	public static String newAnimalType() {
		return "Perro6";
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newAnimalType(), 1);
	}
	
}
