package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * An entity that represents a pet.
 * 
 * @author Javier Quintas Bergantiño
 */

 public class Pet {
    private int id;
    private String name;
    private String animalType;
    private int owner_id;

    Pet(){}

    public Pet(int id, String name, String animalType, int owner_id) {
        this.id = id;
        this.setName(name);
        this.setAnimalType(animalType);
        this.owner_id = owner_id;
    }

    public int getId() {
        return id;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = requireNonNull(name, "Name can't be null");
    }

    public String getAnimalType() {
        return animalType;
    }

    public void setAnimalType(String animalType) {
        this.animalType = requireNonNull(animalType, "Animal type can't be null");
    }

    public int getOwnerId() {
        return owner_id;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + id;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
    }

 }