/*
 * DAA Example
 *
 * Copyright (C) 2019 - Miguel Reboiro-Jato.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

import {Component, EventEmitter, Input, OnInit, Output} from '@angular/core';
import {PetModel} from '../../models/pet.model';
import {PersonModel} from '../../../people/models/person.model';

@Component({
  selector: 'app-pets-form',
  templateUrl: './pets-form.component.html',
  styleUrls: ['./pets-form.component.scss']
})
export class PetsFormComponent {
  public activePet: PetModel;

  @Output()
  public readonly modify: EventEmitter<PetModel>;
  @Output()
  public readonly clean: EventEmitter<never>;

  @Input()
  public people: PersonModel[] = [];

  public name: string;
  public animalType: string;
  public owner_id: number;

  public constructor() {
    this.modify = new EventEmitter<PetModel>();
    this.clean = new EventEmitter<never>();
  }

  @Input()
  public set pet(pet: PetModel) {
    this.activePet = pet;
    this.name = pet.name;
    this.animalType = pet.animalType;
    this.owner_id = pet.ownerId;
  }

  public get pet(): PetModel {
    return this.activePet;
  }

  public onModify() {
    this.modify.emit({
      id: this.pet.id,
      name: this.name,
      animalType: this.animalType,
      ownerId: this.owner_id
    });
    
  }

  public onClean() {
    this.clean.emit();
  }
}
