package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	@Test
	public void testPetIntStringInt() {
		final int id = 1;
		final String name = "Fofo";
		final int owner = 7;
		
		final Pet pet = new Pet(id, name, owner);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntNullName() {
		new Pet(1, null, 7);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringIntNullOwner() {
		new Pet(1, "Fofo", null);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int owner = 7;
		
		final Pet pet = new Pet(id, "Fofo", owner);
		pet.setName("Juancho");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Juancho")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Fofo", 7);
		
		pet.setName(null);
	}

	@Test
	public void testSetOwner() {
		final int id = 1;
		final String name = "Fofo";
		
		final Pet pet = new Pet(id, name, 7);
		pet.setOwner(8);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getOwner(), is(equalTo(8)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullOwner() {
		final Pet pet = new Pet(1, "Fofo", 7);
		
		pet.setOwner(null);
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", 1);
		final Pet petB = new Pet(1, "Name B", 2);
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "owner")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
