import {Component, EventEmitter, Input, Output} from '@angular/core';
import {PetModel} from '../../models/pet.model';
import { PersonModel } from 'src/app/modules/people/models/person.model';
import { PeopleService } from 'src/app/modules/people/services/people.service';

@Component({
  selector: 'app-pets-form',
  templateUrl: './pets-form.component.html',
  styleUrls: ['./pets-form.component.scss']
})
export class PetsFormComponent {

  public activePet: PetModel;

  @Output()
  public readonly modify: EventEmitter<PetModel>;
  @Output()
  public readonly clean: EventEmitter<never>;

  public name: string;
  public owner: number;
  public people: PersonModel[];

  public constructor(private readonly peopleService: PeopleService) {
    this.modify = new EventEmitter<PetModel>();
    this.clean = new EventEmitter<never>();
  }

  public ngOnInit(): void {
    this.peopleService.list()
      .subscribe(people => this.people = people);
  }

  @Input()
  public set pet(pet: PetModel) {
    this.activePet = pet;
    this.name = pet.name;
    this.owner = pet.owner;
  }

  public get pet(): PetModel {
    return this.activePet;
  }

  public onModify() {
    this.modify.emit({
      id: this.pet.id,
      name: this.name,
      owner: this.owner
    });
  }

  public onClean() {
    this.clean.emit();
  }

}
