package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetsDataset {
	private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Pepe", "Pienso",1),
			new Pet(2, "Ali", "Pescado",2),
			new Pet(3, "Nico", "Pienso",3),
			new Pet(4, "Kiko", "Pienso",4),
			new Pet(5, "Blanca", "Atún",7),
			new Pet(6, "Copito", "Pienso",6),
			new Pet(7, "Perico", "Pienso",7),
			new Pet(8, "Shiro", "Carne",8),
			new Pet(9, "Pancho", "Pollo",9),
			new Pet(10, "Mimi", "Atun",10)
		};
	}
	
	public static Pet[] petsOfOwner(int ownerId) {
		return stream(pets())
			.filter(pet -> pet.getId_person() == ownerId)
			.toArray(Pet[]::new);
	}
	
	public static Pet[] petsWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}

	public static int existentId() {
		return 5;
	}
	
	public static int nonExistentId() {
		return 34;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Jane", "palitos", 18);
	}
	
	public static String newName() {
		return "John";
	}
	
	public static String newFood() {
		return "Maiz";
	}
	public static int newIdPerson() {
		return 7;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newFood(),newIdPerson());
	}
}
