package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

/**
 * An entity that represents a pet.
 * 
 * @author Iria Martínez Álvarez
 */
public class Pet {
	private int id;
	private String name;
	private String food;
	private int id_person;

	
	// Constructor needed for the JSON conversion
	Pet() {}
	
	/**
	 * Constructs a new instance of {@link Pet}.
	 *
	 * @param id identifier of the pet.
	 * @param name name of the pet.
	 * @param food food of the pet.
	 * @param id_person id_person of the pet.
	 */
	public Pet(int id, String name, String food, int id_person) {
		this.id = id;
		this.setName(name);
		this.setFood(food);
		this.setId_person(id_person);

	}
	
	/**
	 * Returns the identifier of the pet.
	 * 
	 * @return the identifier of the pet.
	 */
	public int getId() {
		return id;
	}

	/**
	 * Returns the name of the pet.
	 * 
	 * @return the name of the pet.
	 */
	public String getName() {
		return name;
	}

	/**
	 * Set the name of this pet.
	 * 
	 * @param name the new name of the pet.
	 * @throws NullPointerException if the {@code name} is {@code null}.
	 */
	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");
	}

	/**
	 * Returns the food of the pet.
	 * 
	 * @return the food of the pet.
	 */
	public String getFood() {
		return food;
	}

	/**
	 * Set the food of this pet.
	 * 
	 * @param food the new food of the pet.
	 * @throws NullPointerException if the {@code food} is {@code null}.
	 */
	public void setFood(String food) {
		this.food = requireNonNull(food, "Food can't be null");
	}
	/**
	 * Returns the id_person of the pet.
	 * 
	 * @return the id_person of the pet.
	 */
	public int getId_person() {
		return id_person;
	}

	/**
	 * Set the id_person of this pet.
	 * 
	 * @param id_person the new id_person of the pet.
	 * @throws NullPointerException if the {@code id_person} is {@code id_person}.
	 */
	public void setId_person(int id_person) {
		this.id_person = requireNonNull(id_person, "Id_person can't be null");
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + id;
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
}
