package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.hamcrest.MatcherAssert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {
	@Test
	public void testPetIntStringString() {
		final int id = 1;
		final String name = "John";
		final String food = "Maiz";
		final int id_person = 7;

		
		final Pet pet = new Pet(id, name, food,id_person);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getFood(), is(equalTo(food)));
		assertThat(pet.getId_person(), is(equalTo(id_person)));

	}

	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringNullName() {
		new Pet(1, null, "Maiz",7);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringNullFood() {
		new Pet(1, "John", null,7);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final String food = "Maiz";
		final int id_person = 7;

		final Pet pet = new Pet(id, "John", food,id_person);
		pet.setName("Juan");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Juan")));
		assertThat(pet.getFood(), is(equalTo(food)));
		assertThat(pet.getId_person(), is(equalTo(id_person)));

	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "John", "Maiz",7);
		
		pet.setName(null);
	}

	@Test
	public void testSetFood() {
		final int id = 1;
		final String name = "John";
		final int id_person = 7;

		final Pet pet  = new Pet(id, name, "Maiz",id_person);
		pet.setFood("Pizza");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getFood(), is(equalTo("Pizza")));
		assertThat(pet.getId_person(), is(equalTo(id_person)));

	}

	@Test(expected = NullPointerException.class)
	public void testSetNullFood() {
		final Pet pet = new Pet(1, "John", "Maiz",7);
		
		pet.setFood(null);
	}

	@Test
	public void testEqualsObject() {
		final Pet petA = new Pet(1, "Name A", "Food A",7);
		final Pet petB = new Pet(1, "Name B", "Food B",7);
		
		assertTrue(petA.equals(petB));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "food","id_person")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
