var PetsView = (function() {//creo clase
	var dao;
	
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	//estas variables son atributos privados clase
	var self;
	var peopleView;
	var formId = 'pets-form';
	var listId = 'pets-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	function PetsView(petsDao, formContainerId, listContainerId) {//constructor
		dao = petsDao;//se guarda internamente
		self = this;
		//metodos internas=publicas
		this.init = function(peopleView,id) {//peopleView se pasa para el volver
			peopleView=peopleView;
			self.peopleView=peopleView;
			
			id_person=id;

			insertPetsForm($('#' + formContainerId));//se guarda form de pets- busco elem con ese id. Se añade html
			insertPetsList($('#' + listContainerId));//se guarda lista de pets- se añade html
		
			dao.listPets(id_person,function(pets) {//se pide al dao que pida al backend lista de pets
				$.each(pets, function(key, pet) {//para cada pet
					appendToTable(pet);//se añade tabla
				});
			},
			function() {
			    	alert('No has sido posible acceder al listado de mascotas.');
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {//se coge formulario en evento submit y se sustituye por peticion js
				var pet = self.getPetInForm();
				
				if (self.isEditing()) {//si se esta editando
					dao.modifyPet(pet,
						function(pet) {
							$('#pet-' + pet.id + ' td.name').text(pet.name);
							$('#pet-' + pet.id + ' td.id_person').text(pet.id_person);
							$('#pet-' + pet.id + ' td.food').text(pet.food);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPet(pet,
						function(pet) {//si se esta añadiendo
							appendToTable(pet,peopleView);//añade tabla
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
            $('#btnReturn').click(this.returnPeople);
		};

		this.getPetInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
				'name': form.find('input[name="name"]').val(),
				'id_person': form.find('input[name="id_person"]').val(),
				'food': form.find('input[name="food"]').val()

			};
		};

		this.getPetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'name': row.find('td.name').text(),
					'id_person': row.find('td.id_person').text(),
					'food': row.find('td.food').text()

				};
			} else {
				return undefined;
			}
		};
		
		this.editPet = function(id) {
			var pet = self.getPetInRow(id);

			if (pet !== undefined) {
				var form = $(formQuery);
				
				form.find('input[name="id"]').val(pet.id);
				form.find('input[name="name"]').val(pet.name);
				form.find('input[name="id_person"]').val(pet.id_person);
				form.find('input[name="food"]').val(pet.food);			

				$('input#btnSubmit').val('Modificar');
			}
		};
		
		this.deletePet = function(id) {
			if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
				dao.deletePet(id,
					function() {
						$('tr#pet-' + id).remove();
					},
					showErrorMessage
				);
			}
		};

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
		this.returnPeople = function() {
			window.history.back();
		};
	};
	
	var insertPetsList = function(parent) {
		parent.append(
			'<table id="' + listId + '" class="table">\
				<thead>\
					<tr class="row">\
						<th class="col-sm-3">Nombre</th>\
						<th class="col-sm-3">Id_person</th>\
						<th class="col-sm-3">Comida</th>\
						<th class="col-sm-3">&nbsp;</th>\
					</tr>\
				</thead>\
				<tbody>\
				</tbody>\
			</table>'
		);
	};
	//metodos privadas
			
	var insertPetsForm = function(parent) {
		parent.append(
			'<form id="' + formId + '" class="mb-5 mb-10">\
				<h1>Mascotas</h1>\
				<input name="id" type="hidden" value=""/>\
					<div class="col-sm-3">\
						<input id="btnReturn"  type="button" value="Volver" class="btn btn-primary my-2" />\
					</div>\
				<div class="row">\
					<div class="col-sm-3">\
						<input name="name" type="text" value="" input-sm placeholder="Nombre" class="form-control" required/>\
					</div>\
					<div class="col-sm-3">\
						<input name="id_person" type="text" input-sm value="' + id_person + '" placeholder="Propietario" class="form-control" readonly />\
					</div>\
					<div class="col-sm-3">\
						<input name="food" type="text" value="" input-sm placeholder="Comida" class="form-control" required/>\
					</div>\
					<div class="col-sm-3">\
						<input id="btnSubmit" type="submit" value="Crear" class="btn btn-primary" />\
						<input id="btnClear" type="reset" value="Limpiar" class="btn" />\
					</div>\
				</div>\
			</form>'
		);
	};

	var createPetsRow = function(pet) {
		return '<tr id="pet-'+ pet.id +'" class="row">\
			<td class="name col-sm-3">' + pet.name + '</td>\
			<td class="id_person col-sm-3">' + pet.id_person + '</td>\
			<td class="food col-sm-3">' + pet.food + '</td>\
			<td class="col-sm-3">\
				<a class="edit btn btn-primary" href="#">Editar</a>\
				<a class="delete btn btn-warning" href="#">Eliminar</a>\
			</td>\
		</tr>';
	};

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	};

	var addRowListeners = function(pet) {
		$('#pet-' + pet.id + ' a.edit').click(function() {
			self.editPet(pet.id);
		});
		
		$('#pet-' + pet.id + ' a.delete').click(function() {
			self.deletePet(pet.id);
		});
	};
	
	
	var appendToTable = function(pet,peopleView) {
		$(listQuery + ' > tbody:last')//coge la tabla, coge ultimo elem
			.append(createPetsRow(pet));//se añade elem html
		addRowListeners(pet);//añade listeners(botones)

	};

	return PetsView;
})();
