package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;

import org.junit.Test;

public class PetUnitTest {
	@Test
	public void testPetIntStringStringStringInt() {
		final int id = 1;
		final String name = "Ron";
		final String kind = "Can";
		final String breed = "Moito";
		final int owner = 1;
		
		final Pet pet = new Pet(id, name, kind, breed, owner);
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getKind(), is(equalTo(kind)));
		assertThat(pet.getBreed(), is(equalTo(breed)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringStringIntNullName() {
		new Pet(1, null, "Can", "Moito", 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringStringIntNullKind() {
		new Pet(1, "Ron", null, "Moito", 1);
	}
	
	@Test(expected = NullPointerException.class)
	public void testPetIntStringStringStringIntNullBreed() {
		new Pet(1, "Ron", "Can", null, 1);
	}
	
	@Test
	public void testSetName() {
		final int id = 1;
		final String kind = "Can";
		final String breed = "Moito";
		final int owner = 1;
		
		final Pet pet = new Pet(id, "Ron", kind, breed, owner);
		pet.setName("Blas");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Blas")));
		assertThat(pet.getKind(), is(equalTo(kind)));
		assertThat(pet.getBreed(), is(equalTo(breed)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Ron", "Can", "Moito", 1);
		
		pet.setName(null);
	}
	
	@Test
	public void testSetKind() {
		final int id = 1;
		final String name = "Ron";
		final String breed = "Moito";
		final int owner = 1;
		
		final Pet pet = new Pet(id, name, "Can", breed, owner);
		pet.setKind("Gato");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getKind(), is(equalTo("Gato")));
		assertThat(pet.getBreed(), is(equalTo(breed)));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullKind() {
		final Pet pet = new Pet(1, "Ron", "Can", "Moito", 1);
		
		pet.setKind(null);
	}
	
	@Test
	public void testSetBreed() {
		final int id = 1;
		final String name = "Ron";
		final String kind = "Can";
		final int owner = 1;
		
		final Pet pet = new Pet(id, name, kind, "Moito", owner);
		pet.setBreed("Pouco");
		
		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getKind(), is(equalTo(kind)));
		assertThat(pet.getBreed(), is(equalTo("Pouco")));
		assertThat(pet.getOwner(), is(equalTo(owner)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullBreed() {
		final Pet pet = new Pet(1, "Ron", "Can", "Moito", 1);
		
		pet.setBreed(null);
	}

}
