package es.uvigo.esei.daa.entities;

import static java.util.Objects.requireNonNull;

public class Pet {
	
    private int id;
	private String name;
	private String kind;
	private String breed;
	private int owner;
	
	Pet(){}
	
	public Pet(int id, String name, String kind, String breed, int owner) {
		this.setId(id);
		this.setName(name);
		this.setKind(kind);
		this.setBreed(breed);
		this.setOwner(owner);
	}
	
	public int getId() {
		return id;
	}
	
	public void setId(int id) {
		this.id = id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = requireNonNull(name, "Name can't be null");;
	}
	
	public String getKind() {
		return kind;
	}
	
	public void setKind(String kind) {
		this.kind = requireNonNull(kind, "Kind can't be null");;
	}
	
	public String getBreed() {
		return breed;
	}
	
	public void setBreed(String breed) {
		this.breed = requireNonNull(breed, "Breed can't be null");;
	}
	
	public int getOwner() {
		return owner;
	}
	
	public void setOwner(int owner) {
		this.owner = owner;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (int) (prime * result + id);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
}

