package es.uvigo.esei.daa.rest;

import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

import java.net.URI;
import java.util.List;

import es.uvigo.esei.daa.dao.PetDAO;
import es.uvigo.esei.daa.entities.Pet;

@Path("/pets")
@Produces(MediaType.APPLICATION_JSON)
public class PetsResource {
	@Inject PetDAO petDAO;
	
	@Context
    private UriInfo uriInfo;
	
	public PetsResource() {
		
	}
	
    @GET
    @Produces({MediaType.APPLICATION_JSON})
    public Response searchPets() {
        List<Pet> pets = petDAO.buscarTodos();
        GenericEntity<List<Pet>> entidadJSON = new GenericEntity<List<Pet>>(pets) {};
        return Response.ok(entidadJSON).build();
    }
    
    @GET
    @Produces({MediaType.APPLICATION_JSON})
    @Path("{id:[0­9]+}")
    public Response  buscarAutor(@PathParam("id") Long id) {
        Pet pet = petDAO.buscarPorId(id);
        if (pet != null) {
            return Response.ok(pet).build();
        } else {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }
	
    @POST
    @Consumes({MediaType.APPLICATION_JSON})
    public Response createPet(Pet pet) {
        try {
            Pet newPet = petDAO.crear(pet);
            URI newPetURI = uriInfo.getAbsolutePathBuilder().path(newPet.getId().toString()).build();
            return Response.created(newPetURI).build();
        } catch (Exception e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
    
    @PUT
    @Consumes({MediaType.APPLICATION_JSON})
    @Path("{id:[0­9]+}")
    public Response updatePet(Pet pet) {
        try {
            petDAO.actualizar(pet);
            return Response.noContent().build();
        } catch (Exception e) {
            return Response.status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }
    
    @DELETE
    @Path("{id:[0­9]+}")
    public Response deletePet(@PathParam("id") Long id) {
        Pet pet = petDAO.buscarPorId(id);
        if (pet != null) {
            petDAO.eliminar(pet);
            return Response.noContent().build();
        } else {
            return Response.status(Response.Status.NOT_FOUND).build();
        }
    }
	
}
