package es.uvigo.esei.daa.entities;

import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.validation.constraints.Size;

@Entity
public class Pet implements Serializable {
	
	@Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    Long id;
	
	@Size(min = 0, max = 30)
    @Column(length = 30, nullable = false)
	String name;
	
	@Size(min = 0, max = 30)
    @Column(length = 30, nullable = false)
	private String kind;
	
	@Size(min = 0, max = 30)
    @Column(length = 30, nullable = false)
	private String breed;
	
	@ManyToOne
	Person owner;
	
	Pet(){}
	
	public Pet(int id, String name, String kind, String breed, Person owner) {
		this.setName(name);
		this.setKind(kind);
		this.setBreed(breed);
		this.setOwner(owner);
	}
	
	public Long getId() {
		return id;
	}
	
	public String getName() {
		return name;
	}
	
	public void setName(String name) {
		this.name = name;
	}
	
	public String getKind() {
		return kind;
	}
	
	public void setKind(String kind) {
		this.kind = kind;
	}
	
	public String getBreed() {
		return breed;
	}
	
	public void setBreed(String breed) {
		this.breed = breed;
	}
	
	public Person getOwner() {
		return owner;
	}
	
	public void setOwner(Person owner) {
		this.owner = owner;
	}
	
	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = (int) (prime * result + id);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (!(obj instanceof Pet))
			return false;
		Pet other = (Pet) obj;
		if (id != other.id)
			return false;
		return true;
	}
}
