package es.uvigo.esei.daa.dao;

import java.lang.reflect.ParameterizedType;
import java.util.List;

import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;

public abstract class GenericDAO<T> {

    @PersistenceContext(unitName = "daa-PU")
    protected EntityManager em;

    protected Class<T> claseEntidad;

    private void establecerClaseEntidad() {
        this.claseEntidad = (Class<T>) ((ParameterizedType) getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    }

    public T crear(T entidad) {
        em.persist(entidad);
        return entidad;
    }

    public T actualizar(T entidad) {
        return em.merge(entidad);
    }

    public void eliminar(T entidad) {
        em.remove(em.merge(entidad));
    }

    public T buscarPorId(Object id) {
        if (this.claseEntidad == null) {
            establecerClaseEntidad();
        }
        return em.find(this.claseEntidad, id);
    }

    public List<T> buscarTodos() {
        if (this.claseEntidad == null) {
            establecerClaseEntidad();
        }
        
        CriteriaBuilder builder = em.getCriteriaBuilder();
        CriteriaQuery<T> query = builder.createQuery(this.claseEntidad);
        query.select(query.from(this.claseEntidad));
        return em.createQuery(query).getResultList();
    }

}
