var PeopleView = (function() {
	var dao;
	var pets;
	
	// Referencia a this que permite acceder a las funciones públicas desde las funciones de jQuery.
	var self;
	var selfpets;
	
	var formId = 'people-form';
	var listId = 'people-list';
	var formQuery = '#' + formId;
	var listQuery = '#' + listId;
	
	var petsFormId = 'pets-form';
	var petsListId = 'pets-list';
	var petsFormQuery = '#' + petsFormId;
	var petsListQuery = '#' + petsListId;
	
	function PeopleView(peopleDao, petsDAO, formContainerId, listContainerId) {
		dao = peopleDao;
		pets = petsDAO;
		self = this;
		
		insertPeopleForm($('#' + formContainerId));
		insertPeopleList($('#' + listContainerId));
		
		this.init = function() {
			dao.listPeople(function(people) {
				$.each(people, function(key, person) {
					appendToTable(person);
				});
			});
			
			// La acción por defecto de enviar formulario (submit) se sobreescribe
			// para que el envío sea a través de AJAX
			$(formQuery).submit(function(event) {
				var person = self.getPersonInForm();
				
				if (self.isEditing()) {
					dao.modifyPerson(person,
						function(person) {
							$('#person-' + person.id + ' td.name').text(person.name);
							$('#person-' + person.id + ' td.surname').text(person.surname);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				} else {
					dao.addPerson(person,
						function(person) {
							appendToTable(person);
							self.resetForm();
						},
						showErrorMessage,
						self.enableForm
					);
				}
				
				return false;
			});
			
			petsView = new PetsView();
			petsView.init();
			
			$('#btnClear').click(this.resetForm);
		};

		this.getPersonInForm = function() {
			var form = $(formQuery);
			return {
				'id': form.find('input[name="id"]').val(),
				'name': form.find('input[name="name"]').val(),
				'surname': form.find('input[name="surname"]').val()
			};
		};

		this.getPersonInRow = function(id) {
			var row = $('#person-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'name': row.find('td.name').text(),
					'surname': row.find('td.surname').text()
				};
			} else {
				return undefined;
			}
		};
		
		this.editPerson = function(id) {
			var row = $('#person-' + id);

			console.log(row);
			if (row !== undefined) {
				var form = $(formQuery);
				console.log(form);
				console.log(row.find('td.name').text());
				console.log(row.find('td.surname').text());
				
				form.find('input[name="id"]').val(id);
				form.find('input[name="name"]').val(row.find('td.name').text());
				form.find('input[name="surname"]').val(row.find('td.surname').text());
			}
		}

		this.isEditing = function() {
			return $(formQuery + ' input[name="id"]').val() != "";
		};

		this.disableForm = function() {
			$(formQuery + ' input').prop('disabled', true);
		};

		this.enableForm = function() {
			$(formQuery + ' input').prop('disabled', false);
		};

		this.resetForm = function() {
			$(formQuery)[0].reset();
			$(formQuery + ' input[name="id"]').val('');
			$('#btnSubmit').val('Crear');
		};
	}
	
	var insertPeopleList = function(parent) {
		parent.append(
			'<table id="' + listId + '">\
				<tr>\
					<th>Nombre</th>\
					<th>Apellido</th>\
					<th></th>\
					<th></th>\
				</tr>\
			</table>'
		);
	}

	var insertPeopleForm = function(parent) {
		parent.append(
			'<form id="' + formId + '">\
				<input name="id" type="hidden" value=""/>\
				<input name="name" type="text" value="" />\
				<input name="surname" type="text" value=""/>\
				<input id="btnSubmit" type="submit" value="Create"/>\
				<input id="btnClear" type="reset" value="Limpiar"/>\
			</form>'
		);
	}

	var createPersonRow = function(person) {
		return '<tr id="person-'+ person.id +'">\
			<td class="name">' + person.name + '</td>\
			<td class="surname">' + person.surname + '</td>\
			<td>\
				<a class="edit" href="#">Edit</a>\
			</td>\
			<td>\
				<a class="delete" href="#">Delete</a>\
			</td>\
			<td>\
				<a class="pets" href="#">View Pets</a>\
			</td>\
		</tr>';
	}

	var showErrorMessage = function(jqxhr, textStatus, error) {
		alert(textStatus + ": " + error);
	}

	var addRowListeners = function(person) {
		$('#person-' + person.id + ' a.edit').click(function() {
			self.editPerson(person.id);
			$('input#btnSubmit').val('Modificar');
		});
		
		$('#person-' + person.id + ' a.delete').click(function() {
			if (confirm('Está a punto de eliminar a una persona. ¿Está seguro de que desea continuar?')) {
				dao.deletePerson(person.id,
					function() {
						$('tr#person-' + person.id).remove();
					},
					showErrorMessage
				);
			}
		});
		
		$('#person-' + person.id + ' a.pets').click(function() {
			showPeoplePets(person);
		});
	}

	var appendToTable = function(person) {
		$(listQuery + ' > tbody:last')
			.append(createPersonRow(person));
		addRowListeners(person);
	}
	
	var showPeoplePets = function(person) {
		pets.listPeoplePets(person, function(pets) {
			deletePetsTable();
			createPetsTable(person.name);
			$.each(pets, function (key, pet) {
				addPetToTable(pet);
			});
		});
	}
	
	var deletePetsTable = function(){
		$(petsListQuery).remove();
	}
	
	var createPetsTable = function (owner){
		$('div').append(
			'<table class="rwd-table" id="' + petsListId + '">\
			<tr class="owner">\
				<th>Mascotas de: ' + owner + '</th>\
				<th></th>\
				<th></th>\
				<th></th>\
				<th></th>\
			</tr>\
			<tr>\
				<th>Nombre</th>\
				<th>Especie</th>\
				<th>Raza</th>\
				<th></th>\
				<th></th>\
			</tr>\
			</table>'
		);
	}

	var addPetToTable = function (pet){
		$(petsListQuery  + ' > tbody:last').append(petToRow(pet));
		addPetListeners(pet);
	}
	
	var addPetListeners = function(pet) {
		$('#pet-' + pet.id + ' a.editPet').click(function() {
			petToForm(pet);
			$('input#petsBtnSubmit').val('Modificar');
		});
		
		$('#pet-' + pet.id + ' a.deletePet').click(function() {
			if(confirm("Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?")) {
				pets.deletePet(pet.id,
					function () {
						$('tr#pet-' + pet.id).remove();
					},
					showErrorMessage
				);
			}
		});
	}
	
	var insertPetList = function(parent) {
		parent.append(
			'<table id="' + petsListId + '">\
				<tr>\
					<th>Nombre</th>\
					<th>Especie</th>\
					<th>Raza</th>\
					<th></th>\
					<th></th>\
				</tr>\
			</table>'
		);
	}

	var insertPetForm = function(parent) {
		parent.append(
			'<form id="' + petsFormId + '">\
				<input name="id" type="hidden" value=""/>\
				<input name="name" type="text" value="" />\
				<input name="kind" type="text" value=""/>\
			    <input name="breed" type="text" value=""/>\
				<input name="owner" type="hidden" value=""/>\
				<input id="petsBtnSubmit" type="submit" value="Create"/>\
				<input id="btnClear" type="reset" value="Limpiar"/>\
			</form>'
		);
	}

	var createPetRow = function(pet) {
		return '<tr id="pet-'+ pet.id +'">\
			<td class="name">' + pet.name + '</td>\
			<td class="kind">' + pet.kind + '</td>\
			<td class="breed">' + pet.breed + '</td>\
			<td class="owner">' + pet.owner + '</td>\
			<td>\
				<a class="edit" href="#">Edit</a>\
			</td>\
			<td>\
				<a class="delete" href="#">Delete</a>\
			</td>\
		</tr>';
	}
	
	var petToRow = function(pet) {
		console.log(pet);
		return '<tr id="pet-' + pet.id + '">\
			<td class="name">' + pet.name + '</td>\
			<td class="kind">' + pet.kind + '</td>\
			<td class="breed">' + pet.breed + '</td>\
			<td id="owner" type="hidden" value="' + pet.owner + '">\
			<td>\
				<a class="editPet" href="#">Edit</a>\
			</td>\
			<td>\
				<a class="deletePet" href="#">Delete</a>\
			</td>\
		</tr>';
	}
	
	function petToForm(pet) {
		var form = $(petsFormQuery);
		console.log(pet.id);
		form.find('input[name="petId"]').val(pet.id);
		form.find('input[name="petName"]').val(pet.name);
		form.find('input[name="kind"]').val(pet.kind);
		form.find('input[name="breed"]').val(pet.breed);
		form.find('input[name="owner"]').val(pet.owner);
	}
	
	var petsForm = function() {
		$("body").append(
			'<form id="' + petsFormId + '">\
				<input name="petId" type="hidden" value=""/>\
				Nombre: <input name="petName" type="text" value="" />\
				Especie: <input name="kind" type="text" value="" />\
				Raza: <input name="breed" type="text" value="" />\
				Propietario: <input name="owner" type="text" value="" />\
				<input id="petsBtnSubmit" type="submit" value="Crear"/>\
				<input id="btnClear" type="reset" value="Limpiar"/>\
			</form>'
		);
	}
	
	var formToPet = function() {
		var form = $(petsFormQuery);
		return {
			'id': form.find('input[name="petId"]').val(),
			'name': form.find('input[name="petName"]').val(),
			'kind': form.find('input[name="kind"]').val(),
			'breed': form.find('input[name="breed"]').val(),
			'owner': form.find('input[name="owner"]').val()
		};
	};

	
	function PetsView() {
		
		selfpets = this;
		
		this.init = function() {
			
			petsForm();
			
			$(petsFormQuery).submit(function(event) {
				
				var pet = selfpets.getPetInForm();
				
				if (selfpets.isEditing()) {
					pets.modifyPet(pet,
						function(pet) {
							$('#pet-' + pet.id + ' td.name').text(pet.name);
							$('#pet-' + pet.id + ' td.kind').text(pet.kind);
							$('#pet-' + pet.id + ' td.breed').text(pet.breed);
							$('#pet-' + pet.id + ' td.owner').text(pet.owner);
							selfpets.resetForm();
						},
						showErrorMessage,
						selfpets.enableForm
					);
				} else {
					console.log("ola");
					pets.addPet(pet,
						function(pet) {
							selfpets.resetForm();
						},
						showErrorMessage,
						selfpets.enableForm
					);
				}
				
				return false;
			});
			
			$('#btnClear').click(this.resetForm);
		};

		selfpets.getPetInForm = function() {
			var form = $(petsFormQuery);
			return {
				'id': form.find('input[name="petId"]').val(),
				'name': form.find('input[name="petName"]').val(),
				'kind': form.find('input[name="kind"]').val(),
				'breed': form.find('input[name="breed"]').val(),
				'owner': form.find('input[name="owner"]').val()
			};
		};

		selfpets.getPetInRow = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				return {
					'id': id,
					'name': row.find('td.name').text(),
					'kind': row.find('td.kind').text(),
					'breed': row.find('td.breed').text(),
					'owner': row.find('td.owner')
				};
			} else {
				return undefined;
			}
		};
		
		selfpets.editPet = function(id) {
			var row = $('#pet-' + id);

			if (row !== undefined) {
				var form = $(petsFormQuery);
				
				form.find('input[name="petId"]').val(id);
				form.find('input[name="petName"]').val(row.find('td.petName').text());
				form.find('input[name="kind"]').val(row.find('td.kind').text());
				form.find('input[name="breed"]').val(row.find('td.breed').text());
				form.find('input[name="owner"]').val(owner);
			}
		}

		selfpets.isEditing = function() {
			return $(petsFormQuery + ' input[name="petId"]').val() != "";
		};

		selfpets.disableForm = function() {
			$(petsFormQuery + ' input').prop('disabled', true);
		};

		selfpets.enableForm = function() {
			$(petsFormQuery + ' input').prop('disabled', false);
		};

		selfpets.resetForm = function() {
			$(petsFormQuery)[0].reset();
			$(petsFormQuery + ' input[name="petId"]').val('');
			$('#petsBtnSubmit').val('Crear');
		};
	}
	
	return PeopleView;
})();
