class NewPerson extends React.Component {
	addPerson() {
		var name = this.refs.name.value;
		var surname = this.refs.surname.value;
		this.refs.name.value = "";
		this.refs.surname.value = "";
		var person = {'name': name, 'surname': surname};
		$.ajax({
			url: 'rest/people/',
			type: 'POST',
			data: person,
			success: (response) => {
					console.log('Person added!', response);
			}
		});
	}
    render() {
        return (
        	<div>
    			<input type="text" ref="name" placeholder="Enter a person name" />
    			<input type="text" ref="surname" placeholder="Enter a person surname" />
    			<button type="button" className="btn btn-primary" onClick={this.addPerson.bind(this)}>Submit</button>
            </div>
        )
    }
}

class PeopleList extends React.Component{
    render() {
    	var people = this.props.people.map(person =>
            <Person key={person.id} person={person}/>
        );
        return (
        	<div>
        	<NewPerson />
            <table className="table table-striped">
                <tbody>
                    <tr>
                    	<th>#</th>
                        <th>Name</th>
                        <th>Surname</th>
                        <th></th>
                        <th></th>
                        <th></th>
                    </tr>
                    {people}
                </tbody>
            </table>
            </div>
        )
    }
}

class Person extends React.Component{
	constructor(props) {
        super(props);
        this.state = {editable: false, isModalOpen: false};
    }
	handleDelete(id) {
		if (confirm('Está a punto de eliminar a una persona. ¿Está seguro de que desea continuar?')) {
			$.ajax({
				url: 'rest/people/' + id,
				type: 'DELETE',
				success(response) {
					console.log('Person successfully removed');
				 }
			});
		}
    }
	handleEdit(){
		if (this.state.editable) {
			var id = this.refs.id.value;
			var name = this.refs.name.value;
			var surname = this.refs.surname.value;
			var person = {'id': id, 'name': name, 'surname': surname};
		}
		$.ajax({
			url: 'rest/people/' + id,
			type: 'PUT',
			data: person,
			success: (response) => {
					console.log('Person updated!', response);
			}
		});
		this.setState({editable: !this.state.editable});
	}
	openModal() {
		this.setState({isModalOpen: true});
	}
	closeModal() {
		this.setState({isModalOpen: false });
	}
	render() {
		var id = this.state.editable ? <input type='hidden' ref="id" defaultValue={this.props.person.id} /> : <span>{this.props.person.id}</span>;
		var name = this.state.editable ? <input type='text' ref="name" defaultValue={this.props.person.name} /> : <span>{this.props.person.name}</span>;
		var surname = this.state.editable ? <input type='text' ref="surname" defaultValue={this.props.person.surname} /> : <span>{this.props.person.surname}</span>;
		return (
        	<tr>
        		<td>{id}</td>
                <td>{name}</td>
                <td>{surname}</td>
                <td>
                    <a href="#" onClick={() => this.openModal()}>
                        <i className="fa fa-paw" aria-hidden="true"></i>
                    </a>
                    <Modal isOpen={this.state.isModalOpen} onClose={() => this.closeModal()}>
                    	<PetsApp id={this.props.person.id} owner_name={this.props.person.name}/>
                    </Modal>
                </td>
                <td>
                    <a href="#" onClick={this.handleEdit.bind(this, this.props.person.id)}>
                    	{this.state.editable ? 'Submit' : 'Edit' } 
                        <i className="fa fa-edit" aria-hidden="true"></i>
                    </a>
                </td>
                <td>
                    <a href="#" onClick={this.handleDelete.bind(this, this.props.person.id)}>
                        <i className="fa fa-trash-o" aria-hidden="true"></i>
                    </a>
                </td>
            </tr>
        )
    }
}

class App extends React.Component {

    constructor(props) {
        super(props);
        this.state = {people: []};
    }

    componentDidMount() {
        $.ajax({
            url: 'rest/people',
            type: 'GET',
            success: (response) => {
                this.setState({people: response})
            }
        });
    }
    
    componentWillUpdate() {
    	$.ajax({
            url: 'rest/people',
            type: 'GET',
            success: (response) => {
                this.setState({people: response})
            }
        });
    }

    render() {
        return (
            <PeopleList people={this.state.people}/>
        )
    }
}

class NewPet extends React.Component {
	constructor(props) {
        super(props);
    }
	addPet() {
		var name = this.refs.name.value;
		var kind = this.refs.kind.value;
		var breed = this.refs.breed.value;
		var owner = this.props.owner;
		
		this.refs.name.value = "";
		this.refs.kind.value = "";
		this.refs.breed.value = "";

		var pet = {'name': name, 'kind': kind, 'breed': breed, 'owner': owner};
		$.ajax({
			url: 'rest/pets/',
			type: 'POST',
			data: pet,
			success: (response) => {
					console.log('Pet added!', response);
			}
		});
	}
    render() {
        return (
        	<div>
    			<input type="text" ref="name" placeholder="Enter a pet name" />
    			<input type="text" ref="kind" placeholder="Enter a pet kind" />
    			<input type="text" ref="breed" placeholder="Enter a pet breed" />
    			<button type="button" className="btn btn-primary" onClick={this.addPet.bind(this)}>Submit</button>
            </div>
        )
    }
}

class PetsList extends React.Component{
	constructor(props) {
        super(props);
    }
	render() {
    	var pets = this.props.pets.map(pet =>
            <Pet key={pet.id} pet={pet}/>
        );
        return (
        	<div>
        	<center><h1>Pets de {this.props.owner_name}</h1></center>
        	<NewPet owner={this.props.owner}/>
            <table className="table table-striped">
                <tbody>
                    <tr>
                    	<th>#</th>
                        <th>Name</th>
                        <th>Kind</th>
                        <th>breed</th>
                        <th>owner</th>
                        <th></th>
                        <th></th>
                    </tr>
                    {pets}
                </tbody>
            </table>
            </div>
        )
    }
}

class Pet extends React.Component{
	constructor(props) {
        super(props);
        this.state = {editable: false};
    }
	handleDelete(id) {
		if (confirm('Está a punto de eliminar a una mascota. ¿Está seguro de que desea continuar?')) {
			$.ajax({
				url: 'rest/pets/' + id,
				type: 'DELETE',
				success(response) {
					console.log('Pet successfully removed');
				 }
			});
		}
    }
	handleEdit(id){
		if (this.state.editable) {
			var id = id;
			var name = this.refs.name.value;
			var kind = this.refs.kind.value;
			var breed = this.refs.breed.value;
			var owner = this.refs.owner.value;
			var pet = {'id': id, 'name': name, 'kind': kind, 'breed': breed, 'owner': owner};
		}
		$.ajax({
			url: 'rest/pets/' + id,
			type: 'PUT',
			data: pet,
			success: (response) => {
					console.log('Pet updated!', response);
			}
		});
		this.setState({editable: !this.state.editable});
	}
	render() {
		var id = this.state.editable ? <input type='hidden' ref="id" defaultValue={this.props.pet.id} /> : <span>{this.props.pet.id}</span>;
		var name = this.state.editable ? <input type='text' ref="name" defaultValue={this.props.pet.name} /> : <span>{this.props.pet.name}</span>;
		var kind = this.state.editable ? <input type='text' ref="kind" defaultValue={this.props.pet.kind} /> : <span>{this.props.pet.kind}</span>;
		var breed = this.state.editable ? <input type='text' ref="breed" defaultValue={this.props.pet.breed} /> : <span>{this.props.pet.breed}</span>;
		var owner = this.state.editable ? <input type='hidden' ref="owner" defaultValue={this.props.pet.owner} /> : <span>{this.props.pet.owner}</span>;
		return (
        	<tr>
        		<td>{id}</td>
                <td>{name}</td>
                <td>{kind}</td>
                <td>{breed}</td>
                <td>{owner}</td>
                <td>
                    <a href="#" onClick={this.handleEdit.bind(this, this.props.pet.id)}>
                    	{this.state.editable ? 'Submit' : 'Edit' } 
                        <i className="fa fa-edit" aria-hidden="true"></i>
                    </a>
                </td>
                <td>
                    <a href="#" onClick={this.handleDelete.bind(this, this.props.pet.id)}>
                        <i className="fa fa-trash-o" aria-hidden="true"></i>
                    </a>
                </td>
            </tr>
        )
    }
}

class PetsApp extends React.Component {

    constructor(props) {
        super(props);
        this.state = {pets: []};
    }

    componentDidMount() {
        $.ajax({
            url: 'rest/people/' + this.props.id + '/pets' ,
            type: 'GET',
            success: (response) => {
                this.setState({pets: response})
            }
        });
    }
    
    componentWillUnmount() {
    	
    }
    
    componentWillUpdate() {
    	$.ajax({
            url: 'rest/people/' + this.props.id + '/pets' ,
            type: 'GET',
            success: (response) => {
                this.setState({pets: response})
            }
        });
    }
    
    render() {
        return (
        	<PetsList pets={this.state.pets} owner={this.props.id} owner_name={this.props.owner_name} /> 
        )
    }
}

ReactDOM.render(
    <App />,
    document.getElementById('people-container')
)

class Modal extends React.Component {
	render() {
		if (this.props.isOpen === false)
			return null
	
		let modalStyle = {
			position: 'absolute',
			top: '40%',
			left: '50%',
			transform: 'translate(-50%, -50%)',
			zIndex: '9999',
			background: '#fff'
		}

		let backdropStyle = {
			position: 'absolute',
			width: '100%',
			height: '100%',
			top: '0px',
			left: '0px',
			zIndex: '9998',
			background: 'rgba(0, 0, 0, 0.3)'
		}

		return (
			<div>
				<div style={modalStyle}>{this.props.children}</div>
				<div style={backdropStyle} onClick={e => this.close(e)}/>}
			</div>
		)
	}

	close(e) {
		e.preventDefault()
		if (this.props.onClose) {
			this.props.onClose()
		}
	}
}
