package es.uvigo.esei.daa.dataset;

import static java.util.Arrays.binarySearch;
import static java.util.Arrays.stream;

import java.util.Arrays;
import java.util.function.Predicate;

import es.uvigo.esei.daa.entities.Pet;

public final class PetsDataset {
	private PetsDataset() {}
	
	public static Pet[] pets() {
		return new Pet[] {
			new Pet(1, "Ron", "Can", "Moito", 1),
			new Pet(2, "Paul", "Gato", "Alerxico", 2),
			new Pet(3, "Punky", "Gato", "Alerxico", 2)
		};
	}
	
	public static Pet[] peopleWithout(int ... ids) {
		Arrays.sort(ids);
		
		final Predicate<Pet> hasValidId = pet ->
			binarySearch(ids, pet.getId()) < 0;
		
		return stream(pets())
			.filter(hasValidId)
		.toArray(Pet[]::new);
	}
	
	public static Pet pet(int id) {
		return stream(pets())
			.filter(pet -> pet.getId() == id)
			.findAny()
		.orElseThrow(IllegalArgumentException::new);
	}
	
	public static int existentId() {
		return 1;
	}
	
	public static int nonExistentId() {
		return 1234;
	}

	public static Pet existentPet() {
		return pet(existentId());
	}
	
	public static Pet nonExistentPet() {
		return new Pet(nonExistentId(), "Cospe", "Gaivota", "Pepera",1);
	}
	
	public static String newName() {
		return "Tor";
	}
	
	public static String newKind() {
		return "Pe";
	}
	
	public static String newBreed() {
		return "QueFlipas";
	}
	
	public static int newOwner() {
		return 2;
	}
	
	public static Pet newPet() {
		return new Pet(pets().length + 1, newName(), newKind(), newBreed(), newOwner());
	}
}
