package es.uvigo.esei.daa.entities;

import static org.hamcrest.CoreMatchers.equalTo;
import static org.hamcrest.CoreMatchers.is;
import static org.junit.Assert.assertThat;
import static org.junit.Assert.assertTrue;

import org.junit.Test;

import nl.jqno.equalsverifier.EqualsVerifier;
import nl.jqno.equalsverifier.Warning;

public class PetUnitTest {

	@Test
	public void testPetIntStringInt() {
		final int id = 1;
		final String name = "Test";
		final int peopleID = 1;

		final Pet pet = new Pet(id, name, peopleID);

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getPeopleID(), is(equalTo(peopleID)));
	}

	@Test(expected = NullPointerException.class)
	public void testPetNullName() {
		new Pet(1, null, 1);
	}

	@Test
	public void testSetName() {
		final int id = 1;
		final int peopleID = 1;

		final Pet pet = new Pet(id, "Test", peopleID);
		pet.setName("Another Name");

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo("Another Name")));
		assertThat(pet.getPeopleID(), is(equalTo(peopleID)));
	}

	@Test(expected = NullPointerException.class)
	public void testSetNullName() {
		final Pet pet = new Pet(1, "Test", 1);
		
		pet.setName(null);
	}

	@Test
	public void testSetPeopleID() {
		final int id = 1;
		final String name = "Test";

		final Pet pet = new Pet(id, name, 2);
		pet.setPeopleID(1);

		assertThat(pet.getId(), is(equalTo(id)));
		assertThat(pet.getName(), is(equalTo(name)));
		assertThat(pet.getPeopleID(), is(equalTo(1)));
	}

	@Test
	public void testEqualsObject() {
		final Pet pet1 = new Pet(1, "Test 1", 1);
		final Pet pet2 = new Pet(1, "Test 2", 2);
		
		assertTrue(pet1.equals(pet2));
	}

	@Test
	public void testEqualsHashcode() {
		EqualsVerifier.forClass(Pet.class)
			.withIgnoredFields("name", "peopleID")
			.suppress(Warning.STRICT_INHERITANCE)
			.suppress(Warning.NONFINAL_FIELDS)
		.verify();
	}
}
